/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import com.google.common.cache.Cache;
import java.util.Collection;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.util.BaseObject;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.reference.ReferenceValues;
import org.datacleaner.util.CollectionUtils2;

public final class DatastoreReferenceValues
extends BaseObject
implements ReferenceValues<String> {
    private final Datastore _datastore;
    private final Column _column;
    private transient Cache<String, Boolean> _containsValueCache = CollectionUtils2.createCache(1000, 60L);

    public DatastoreReferenceValues(Datastore datastore, Column column) {
        this._datastore = datastore;
        this._column = column;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._datastore);
        identifiers.add(this._column);
    }

    public void clearCache() {
        this._containsValueCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(String value) {
        Boolean result = (Boolean)this._containsValueCache.getIfPresent((Object)value);
        if (result == null) {
            Cache<String, Boolean> cache = this._containsValueCache;
            synchronized (cache) {
                result = (Boolean)this._containsValueCache.getIfPresent((Object)value);
                if (result == null) {
                    result = false;
                    try (DatastoreConnection con = this._datastore.openConnection();){
                        DataContext dataContext = con.getDataContext();
                        Query q = ((SatisfiedWhereBuilder)dataContext.query().from(this._column.getTable()).selectCount().where(this._column).eq(value)).toQuery();
                        try (DataSet dataSet = dataContext.executeQuery(q);){
                            Row row;
                            if (dataSet.next() && (row = dataSet.getRow()) != null) {
                                Number count = (Number)row.getValue(0);
                                if (count != null && count.intValue() > 0) {
                                    result = true;
                                }
                                assert (!dataSet.next());
                            }
                        }
                    }
                    this._containsValueCache.put((Object)value, (Object)result);
                }
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Collection<String> getValues() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

