/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.Close;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.Provided;
import org.datacleaner.components.convert.ConvertToNumberTransformer;
import org.datacleaner.components.convert.ConvertToStringTransformer;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreCatalog;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.SchemaNavigator;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.SimpleSynonym;
import org.datacleaner.reference.Synonym;
import org.datacleaner.reference.SynonymCatalog;
import org.datacleaner.util.CollectionUtils2;
import org.datacleaner.util.ReadObjectBuilder;
import org.datacleaner.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatastoreSynonymCatalog
extends AbstractReferenceData
implements SynonymCatalog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DatastoreSynonymCatalog.class);
    private transient Cache<String, String> _masterTermCache;
    private transient BlockingQueue<DatastoreConnection> _dataContextProviders = new LinkedBlockingQueue<DatastoreConnection>();
    private final String _datastoreName;
    private final String _masterTermColumnPath;
    private final String[] _synonymColumnPaths;
    @Inject
    @Provided
    transient DatastoreCatalog _datastoreCatalog;

    public DatastoreSynonymCatalog(String name, String datastoreName, String masterTermColumnPath, String[] synonymColumnPaths) {
        super(name);
        this._datastoreName = datastoreName;
        this._masterTermColumnPath = masterTermColumnPath;
        this._synonymColumnPaths = synonymColumnPaths;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, DatastoreSynonymCatalog.class).readObject(stream);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._datastoreName);
        identifiers.add(this._masterTermColumnPath);
        identifiers.add(this._synonymColumnPaths);
    }

    @Initialize
    public void init() {
        logger.info("Initializing dictionary: {}", (Object)this);
        Datastore datastore = this.getDatastore();
        DatastoreConnection dataContextProvider = datastore.openConnection();
        this.getDatastoreConnections().add(dataContextProvider);
    }

    @Close
    public void close() {
        DatastoreConnection datastoreConnection = (DatastoreConnection)this.getDatastoreConnections().poll();
        if (datastoreConnection != null) {
            logger.info("Closing dictionary: {}", (Object)this);
            datastoreConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<String, String> getMasterTermCache() {
        if (this._masterTermCache == null) {
            DatastoreSynonymCatalog datastoreSynonymCatalog = this;
            synchronized (datastoreSynonymCatalog) {
                if (this._masterTermCache == null) {
                    this._masterTermCache = CollectionUtils2.createCache(1000, 300L);
                }
            }
        }
        return this._masterTermCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<DatastoreConnection> getDatastoreConnections() {
        if (this._dataContextProviders == null) {
            DatastoreSynonymCatalog datastoreSynonymCatalog = this;
            synchronized (datastoreSynonymCatalog) {
                if (this._dataContextProviders == null) {
                    this._dataContextProviders = new LinkedBlockingQueue<DatastoreConnection>();
                }
            }
        }
        return this._dataContextProviders;
    }

    private Datastore getDatastore() {
        Datastore datastore = this._datastoreCatalog.getDatastore(this._datastoreName);
        if (datastore == null) {
            throw new IllegalStateException("Could not resolve datastore " + this._datastoreName);
        }
        return datastore;
    }

    public String getDatastoreName() {
        return this._datastoreName;
    }

    public String getMasterTermColumnPath() {
        return this._masterTermColumnPath;
    }

    public String[] getSynonymColumnPaths() {
        return Arrays.copyOf(this._synonymColumnPaths, this._synonymColumnPaths.length);
    }

    public Collection<Synonym> getSynonyms() {
        Datastore datastore = this.getDatastore();
        try (DatastoreConnection datastoreConnection = datastore.openConnection();){
            DataContext dataContext = datastoreConnection.getDataContext();
            SchemaNavigator schemaNavigator = datastoreConnection.getSchemaNavigator();
            Column masterTermColumn = schemaNavigator.convertToColumn(this._masterTermColumnPath);
            Column[] columns = schemaNavigator.convertToColumns(this._synonymColumnPaths);
            Table table = masterTermColumn.getTable();
            Query query = dataContext.query().from(table.getName()).select(masterTermColumn).select(columns).toQuery();
            DataSet results = dataContext.executeQuery(query);
            ArrayList<Synonym> synonyms = new ArrayList<Synonym>();
            while (results.next()) {
                Row row = results.getRow();
                synonyms.add(new SimpleSynonym(this.getMasterTerm(row, masterTermColumn), this.getSynonyms(row, table.getColumns())));
            }
            ArrayList<Synonym> arrayList = synonyms;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMasterTerm(String term) {
        String result;
        Cache<String, String> cache;
        if (StringUtils.isNullOrEmpty(term)) {
            return null;
        }
        Cache<String, String> cache2 = cache = this.getMasterTermCache();
        synchronized (cache2) {
            result = (String)cache.getIfPresent((Object)term);
            if (result == null) {
                block35: {
                    Datastore datastore = this.getDatastore();
                    try (DatastoreConnection datastoreConnection = datastore.openConnection();){
                        SchemaNavigator schemaNavigator = datastoreConnection.getSchemaNavigator();
                        Column masterTermColumn = schemaNavigator.convertToColumn(this._masterTermColumnPath);
                        Column[] columns = schemaNavigator.convertToColumns(this._synonymColumnPaths);
                        DataContext dataContext = datastoreConnection.getDataContext();
                        Table table = masterTermColumn.getTable();
                        Query query = dataContext.query().from(table.getName()).select(masterTermColumn).toQuery();
                        ArrayList<FilterItem> filterItems = new ArrayList<FilterItem>();
                        for (int i = 0; i < columns.length; ++i) {
                            Column column = columns[i];
                            if (column.getType().isNumber()) {
                                Number numberValue = ConvertToNumberTransformer.transformValue(term);
                                if (numberValue == null) continue;
                                filterItems.add(new FilterItem(new SelectItem(column), OperatorType.EQUALS_TO, (Object)numberValue));
                                continue;
                            }
                            filterItems.add(new FilterItem(new SelectItem(column), OperatorType.EQUALS_TO, (Object)term));
                        }
                        if (filterItems.isEmpty()) {
                            result = "";
                            break block35;
                        }
                        query.where(new FilterItem[]{new FilterItem(filterItems.toArray(new FilterItem[0]))});
                        try (DataSet dataSet = dataContext.executeQuery(query);){
                            if (dataSet.next()) {
                                Row row = dataSet.getRow();
                                result = this.getMasterTerm(row, masterTermColumn);
                            } else {
                                result = "";
                            }
                        }
                    }
                }
                cache.put((Object)term, (Object)result);
            }
        }
        if ("".equals(result)) {
            result = null;
        }
        return result;
    }

    private String getMasterTerm(Row row, Column column) {
        Object value = row.getValue(column);
        return ConvertToStringTransformer.transformValue(value);
    }

    private String[] getSynonyms(Row row, Column[] columns) {
        ArrayList<String> synonyms = new ArrayList<String>();
        for (Column synonymColumn : columns) {
            String value = (String)row.getValue(synonymColumn);
            synonyms.add(value);
        }
        return synonyms.toArray(new String[0]);
    }
}

