/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.HasName;
import org.apache.metamodel.util.HasNameMapper;
import org.datacleaner.reference.Dictionary;
import org.datacleaner.reference.ReferenceDataCatalog;
import org.datacleaner.reference.StringPattern;
import org.datacleaner.reference.SynonymCatalog;

public class ReferenceDataCatalogImpl
implements ReferenceDataCatalog {
    private static final long serialVersionUID = 1L;
    private final Collection<Dictionary> _dictionaries;
    private final Collection<SynonymCatalog> _synonymCatalogs;
    private final Collection<StringPattern> _stringPatterns;

    public ReferenceDataCatalogImpl() {
        this(new ArrayList<Dictionary>(), new ArrayList<SynonymCatalog>(), new ArrayList<StringPattern>());
    }

    public ReferenceDataCatalogImpl(Collection<Dictionary> dictionaries, Collection<SynonymCatalog> synonymCatalogs, Collection<StringPattern> stringPatterns) {
        String name;
        if (dictionaries == null) {
            throw new IllegalArgumentException("dictionaries cannot be null");
        }
        HashSet<String> uniqueNames = new HashSet<String>();
        for (Dictionary dictionary : dictionaries) {
            name = dictionary.getName();
            if (uniqueNames.contains(name)) {
                throw new IllegalStateException("Duplicate dictionary names: " + name);
            }
            uniqueNames.add(name);
        }
        if (synonymCatalogs == null) {
            throw new IllegalArgumentException("synonymCatalogs cannot be null");
        }
        uniqueNames.clear();
        for (SynonymCatalog synonymCatalog : synonymCatalogs) {
            name = synonymCatalog.getName();
            if (uniqueNames.contains(name)) {
                throw new IllegalStateException("Duplicate synonym catalog names: " + name);
            }
            uniqueNames.add(name);
        }
        if (stringPatterns == null) {
            throw new IllegalArgumentException("stringPatterns cannot be null");
        }
        uniqueNames.clear();
        for (StringPattern stringPattern : stringPatterns) {
            name = stringPattern.getName();
            if (uniqueNames.contains(name)) {
                throw new IllegalStateException("Duplicate string pattern names: " + name);
            }
            uniqueNames.add(name);
        }
        this._dictionaries = dictionaries;
        this._synonymCatalogs = synonymCatalogs;
        this._stringPatterns = stringPatterns;
    }

    @Override
    public String[] getDictionaryNames() {
        return this.getNames(this._dictionaries);
    }

    private String[] getNames(Collection<? extends HasName> items) {
        List names = CollectionUtils.map(items, (Func)new HasNameMapper());
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    @Override
    public Dictionary getDictionary(String name) {
        if (name != null) {
            for (Dictionary d : this._dictionaries) {
                if (!name.equals(d.getName())) continue;
                return d;
            }
        }
        return null;
    }

    @Override
    public String[] getSynonymCatalogNames() {
        return this.getNames(this._synonymCatalogs);
    }

    @Override
    public SynonymCatalog getSynonymCatalog(String name) {
        if (name != null) {
            for (SynonymCatalog sc : this._synonymCatalogs) {
                if (!name.equals(sc.getName())) continue;
                return sc;
            }
        }
        return null;
    }

    @Override
    public StringPattern getStringPattern(String name) {
        if (name != null) {
            for (StringPattern sp : this._stringPatterns) {
                if (!name.equals(sp.getName())) continue;
                return sp;
            }
        }
        return null;
    }

    @Override
    public String[] getStringPatternNames() {
        return this.getNames(this._stringPatterns);
    }
}

