/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.metamodel.util.BaseObject;
import org.datacleaner.reference.ReferenceValues;

public final class SimpleStringReferenceValues
extends BaseObject
implements ReferenceValues<String> {
    private final Set<String> _values;
    private final boolean _caseSensitive;

    public SimpleStringReferenceValues(String[] values, boolean caseSensitive) {
        this._values = new HashSet<String>();
        for (String value : values) {
            this._values.add(value);
        }
        this._caseSensitive = caseSensitive;
    }

    public SimpleStringReferenceValues(Collection<String> values, boolean caseSensitive) {
        this._values = values instanceof Set ? (Set<Object>)values : new HashSet<String>(values);
        this._caseSensitive = caseSensitive;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._values);
        identifiers.add(this._caseSensitive);
    }

    @Override
    public Collection<String> getValues() {
        return Collections.unmodifiableSet(this._values);
    }

    @Override
    public boolean containsValue(String value) {
        boolean contains = this._values.contains(value);
        if (contains) {
            return true;
        }
        if (this._caseSensitive) {
            return false;
        }
        for (String v : this._values) {
            if (!value.equalsIgnoreCase(v)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SimpleStringReferenceValues[" + this._values + "]";
    }
}

