/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.datacleaner.reference.AbstractReferenceData;
import org.datacleaner.reference.MutableSynonym;
import org.datacleaner.reference.Synonym;
import org.datacleaner.reference.SynonymCatalog;
import org.datacleaner.util.ReadObjectBuilder;
import org.datacleaner.util.StringUtils;

public final class SimpleSynonymCatalog
extends AbstractReferenceData
implements SynonymCatalog {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> _synonymMap = new HashMap<String, String>();

    public SimpleSynonymCatalog(String name) {
        super(name);
    }

    public SimpleSynonymCatalog(String name, Synonym ... synonyms) {
        this(name);
        for (Synonym synonym : synonyms) {
            this.addSynonym(synonym);
        }
    }

    public SimpleSynonymCatalog(String name, List<Synonym> synonyms) {
        this(name);
        for (Synonym synonym : synonyms) {
            this.addSynonym(synonym);
        }
    }

    private void addSynonym(Synonym synonym) {
        String masterTerm = synonym.getMasterTerm();
        this._synonymMap.put(masterTerm, masterTerm);
        Collection<String> values = synonym.getSynonyms().getValues();
        for (String value : values) {
            this._synonymMap.put(value, masterTerm);
        }
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._synonymMap);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, SimpleSynonymCatalog.class).readObject(stream, new ReadObjectBuilder.Adaptor(){

            @Override
            public void deserialize(ObjectInputStream.GetField getField, Serializable serializable) throws IOException {
                Object synonyms = getField.get("_synonyms", null);
                if (synonyms instanceof List) {
                    try {
                        Field field = SimpleSynonymCatalog.class.getDeclaredField("_synonymMap");
                        field.setAccessible(true);
                        field.set(SimpleSynonymCatalog.this, new HashMap());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    List synonymsList = (List)synonyms;
                    for (Synonym synonym : synonymsList) {
                        SimpleSynonymCatalog.this.addSynonym(synonym);
                    }
                }
            }
        });
    }

    @Override
    public String getMasterTerm(String term) {
        if (StringUtils.isNullOrEmpty(term)) {
            return null;
        }
        String masterTerm = this._synonymMap.get(term);
        return masterTerm;
    }

    @Override
    public Collection<? extends Synonym> getSynonyms() {
        TreeMap<String, MutableSynonym> synonyms = new TreeMap<String, MutableSynonym>();
        for (Map.Entry<String, String> synonymEntry : this._synonymMap.entrySet()) {
            String masterTerm = synonymEntry.getValue();
            String synonymValue = synonymEntry.getKey();
            MutableSynonym synonym = (MutableSynonym)synonyms.get(masterTerm);
            if (synonym == null) {
                synonym = new MutableSynonym(masterTerm);
                synonyms.put(masterTerm, synonym);
            }
            synonym.addSynonym(synonymValue);
        }
        return synonyms.values();
    }
}

