/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.renderer;

import java.util.Collection;
import java.util.Set;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RendererBean;
import org.datacleaner.api.RendererPrecedence;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.descriptors.MetricDescriptor;
import org.datacleaner.descriptors.MetricParameters;
import org.datacleaner.descriptors.ResultDescriptor;
import org.datacleaner.result.renderer.TextRenderingFormat;
import org.datacleaner.util.LabelUtils;

@RendererBean(value=TextRenderingFormat.class)
public class MetricBasedResultTextRenderer
implements Renderer<AnalyzerResult, String> {
    public RendererPrecedence getPrecedence(AnalyzerResult renderable) {
        return RendererPrecedence.LOWEST;
    }

    public String render(AnalyzerResult result) {
        ResultDescriptor resultDescriptor = Descriptors.ofResult(result);
        Set resultMetrics = resultDescriptor.getResultMetrics();
        StringBuilder sb = new StringBuilder();
        sb.append(result.getClass().getSimpleName());
        sb.append(":");
        int count = 0;
        for (MetricDescriptor metricDescriptor : resultMetrics) {
            if (metricDescriptor.isParameterizedByString() || metricDescriptor.isParameterizedByInputColumn()) continue;
            Number value = metricDescriptor.getValue(result, null);
            sb.append("\n - ");
            sb.append(metricDescriptor.getName());
            sb.append(": ");
            sb.append(LabelUtils.getValueLabel(value));
            ++count;
        }
        for (MetricDescriptor metricDescriptor : resultMetrics) {
            if (!metricDescriptor.isParameterizedByString() || metricDescriptor.isParameterizedByInputColumn()) continue;
            try {
                Collection suggestions = metricDescriptor.getMetricParameterSuggestions(result);
                if (suggestions == null || suggestions.isEmpty()) continue;
                for (String suggestion : suggestions) {
                    Number value = metricDescriptor.getValue(result, new MetricParameters(suggestion));
                    sb.append("\n - ");
                    sb.append(metricDescriptor.getName());
                    sb.append(" (");
                    sb.append(suggestion);
                    sb.append("): ");
                    sb.append(LabelUtils.getValueLabel(value));
                }
                ++count;
            }
            catch (Exception e) {}
        }
        if (count == 0) {
            sb.append("\n (no metrics)");
        }
        return sb.toString();
    }
}

