/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.renderer;

import java.util.Collection;
import org.datacleaner.api.Renderable;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RendererPrecedence;
import org.datacleaner.api.RenderingFormat;
import org.datacleaner.configuration.AnalyzerBeansConfiguration;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.RendererBeanDescriptor;
import org.datacleaner.result.renderer.DefaultRendererInitializer;
import org.datacleaner.result.renderer.RendererInitializer;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RendererFactory {
    private static final Logger logger = LoggerFactory.getLogger(RendererFactory.class);
    private final DescriptorProvider _descriptorProvider;
    private final RendererInitializer _rendererInitializer;

    public RendererFactory(AnalyzerBeansConfiguration configuration) {
        this(configuration, (RendererInitializer)new DefaultRendererInitializer(configuration));
    }

    public RendererFactory(AnalyzerBeansConfiguration configuration, RendererInitializer rendererInitializer) {
        this(configuration.getDescriptorProvider(), rendererInitializer);
    }

    @Deprecated
    public RendererFactory(DescriptorProvider descriptorProvider, RendererInitializer rendererInitializer) {
        this._descriptorProvider = descriptorProvider;
        this._rendererInitializer = rendererInitializer;
    }

    public <I extends Renderable, O> Renderer<? super I, ? extends O> getRenderer(I renderable, Class<? extends RenderingFormat<? extends O>> renderingFormat) {
        RendererSelection bestMatch = null;
        Collection<RendererBeanDescriptor<?>> descriptors = this._descriptorProvider.getRendererBeanDescriptorsForRenderingFormat(renderingFormat);
        for (RendererBeanDescriptor<?> descriptor : descriptors) {
            RendererSelection rendererMatch = this.isRendererMatch(descriptor, renderable, bestMatch);
            if (rendererMatch == null) continue;
            bestMatch = rendererMatch;
        }
        if (bestMatch == null) {
            logger.warn("Didn't find any matches for renderable {} (format={})", renderable, renderingFormat);
            return null;
        }
        Renderer<?, ?> renderer = bestMatch.getRenderer();
        if (logger.isInfoEnabled()) {
            logger.info("Returning renderer '{}' for renderable '{}' in format '{}'", new Object[]{renderer, renderable.getClass().getName(), renderingFormat.getName()});
        }
        return renderer;
    }

    private RendererSelection isRendererMatch(RendererBeanDescriptor<?> rendererDescriptor, Renderable renderable, RendererSelection bestMatch) {
        Class renderableType = rendererDescriptor.getRenderableType();
        if (ReflectionUtils.is(renderable.getClass(), renderableType)) {
            if (bestMatch == null) {
                return this.isRendererCapable(rendererDescriptor, renderable, bestMatch);
            }
            int hierarchyDistance = ReflectionUtils.getHierarchyDistance(renderable.getClass(), renderableType);
            if (hierarchyDistance == 0) {
                return this.isRendererCapable(rendererDescriptor, renderable, bestMatch);
            }
            if (hierarchyDistance <= bestMatch.getHierarchyDistance()) {
                return this.isRendererCapable(rendererDescriptor, renderable, bestMatch);
            }
        }
        return null;
    }

    private RendererSelection isRendererCapable(RendererBeanDescriptor<?> rendererDescriptor, Renderable renderable, RendererSelection bestMatch) {
        RendererPrecedence precedence;
        Renderer renderer = RendererFactory.instantiate(rendererDescriptor);
        if (this._rendererInitializer != null) {
            this._rendererInitializer.initialize(rendererDescriptor, renderer);
        }
        try {
            precedence = renderer.getPrecedence(renderable);
            if (precedence == null) {
                logger.debug("Renderer precedence was null for {}, using MEDIUM", renderer);
                precedence = RendererPrecedence.MEDIUM;
            }
            if (precedence == RendererPrecedence.NOT_CAPABLE) {
                logger.debug("Renderer is not capable of rendering this renderable!");
                return null;
            }
            if (bestMatch != null) {
                RendererPrecedence bestPrecedence = bestMatch.getPrecedence();
                if (precedence.ordinal() < bestPrecedence.ordinal()) {
                    logger.info("Precedence {} did not match or supersede best matching precedence ({}).", (Object)precedence, (Object)bestPrecedence);
                    return null;
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not get precedence of renderer, returning null", (Throwable)e);
            return null;
        }
        Class renderableType = rendererDescriptor.getRenderableType();
        int hierarchyDistance = ReflectionUtils.getHierarchyDistance(renderable.getClass(), renderableType);
        return new RendererSelection(renderer, precedence, hierarchyDistance);
    }

    private static <I extends Renderable, O> Renderer<I, O> instantiate(RendererBeanDescriptor<?> descriptor) {
        Class componentClass = descriptor.getComponentClass();
        Renderer renderer = (Renderer)ReflectionUtils.newInstance(componentClass);
        return renderer;
    }

    private static class RendererSelection {
        private final Renderer<?, ?> renderer;
        private final RendererPrecedence precedence;
        private final int hierarchyDistance;

        public RendererSelection(Renderer<?, ?> renderer, RendererPrecedence precedence, int hierarchyDistance) {
            this.renderer = renderer;
            this.precedence = precedence;
            this.hierarchyDistance = hierarchyDistance;
        }

        public Renderer<?, ?> getRenderer() {
            return this.renderer;
        }

        public RendererPrecedence getPrecedence() {
            return this.precedence;
        }

        public int getHierarchyDistance() {
            return this.hierarchyDistance;
        }
    }
}

