/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.result.renderer;

import javax.inject.Inject;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.AnalyzerResultFuture;
import org.datacleaner.api.Renderable;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RendererBean;
import org.datacleaner.api.RendererPrecedence;
import org.datacleaner.result.renderer.RendererFactory;
import org.datacleaner.result.renderer.TextRenderingFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RendererBean(value=TextRenderingFormat.class)
public class ToStringFutureTextRenderer
implements Renderer<AnalyzerResultFuture<? extends AnalyzerResult>, String> {
    Logger logger = LoggerFactory.getLogger(ToStringFutureTextRenderer.class);
    @Inject
    RendererFactory _rendererFactory;

    public RendererPrecedence getPrecedence(AnalyzerResultFuture<? extends AnalyzerResult> renderable) {
        return RendererPrecedence.MEDIUM;
    }

    public String render(AnalyzerResultFuture<? extends AnalyzerResult> renderable) {
        StringBuilder resultString = new StringBuilder();
        try {
            AnalyzerResult result = renderable.get();
            Renderer renderer = this._rendererFactory.getRenderer(result, TextRenderingFormat.class);
            if (renderer != null) {
                this.logger.debug("renderer.render({})", (Object)result);
                CharSequence component = (CharSequence)renderer.render((Renderable)result);
                resultString.append(component);
                return resultString.toString();
            }
            String message = "No renderer found for result type " + result.getClass().getName();
            this.logger.error(message);
            throw new IllegalStateException(message);
        }
        catch (RuntimeException error) {
            String message = "Unable to fetch result";
            this.logger.error(message, (Throwable)error);
            throw new IllegalStateException(message, error);
        }
    }
}

