/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import com.google.common.cache.Cache;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.RowAnnotationImpl;
import org.datacleaner.util.CollectionUtils2;

public abstract class AbstractRowAnnotationFactory
implements RowAnnotationFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<RowAnnotationImpl, AtomicInteger> _rowCounts = new ConcurrentHashMap<RowAnnotationImpl, AtomicInteger>();
    private final Integer _storedRowsThreshold;
    private final transient Cache<Integer, Boolean> _cachedRows = CollectionUtils2.createCache(10000, 600L);

    public AbstractRowAnnotationFactory(Integer storedRowsThreshold) {
        this._storedRowsThreshold = storedRowsThreshold == null ? Integer.valueOf(Integer.MAX_VALUE) : storedRowsThreshold;
    }

    @Override
    public void annotate(InputRow[] rows, RowAnnotation annotation) {
        for (InputRow row : rows) {
            this.annotate(row, 1, annotation);
        }
    }

    @Override
    public final void annotate(InputRow row, int distinctCount, RowAnnotation annotation) {
        RowAnnotationImpl ann = (RowAnnotationImpl)annotation;
        AtomicInteger count = this.getCounter(ann);
        boolean storeRow = true;
        if (this._storedRowsThreshold != null && count.getAndIncrement() >= this._storedRowsThreshold) {
            storeRow = false;
        }
        if (storeRow) {
            Boolean previously;
            int rowId = row.getId();
            if (this._cachedRows != null && (previously = this._cachedRows.asMap().putIfAbsent(rowId, true)) == null) {
                this.storeRowValues(rowId, row, distinctCount);
            }
            this.storeRowAnnotation(rowId, annotation);
        }
        ann.incrementRowCount(distinctCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicInteger getCounter(RowAnnotationImpl ann) {
        AtomicInteger count = this._rowCounts.get(ann);
        if (count == null) {
            if (this._rowCounts instanceof ConcurrentMap) {
                ConcurrentMap concurrentMap = (ConcurrentMap)this._rowCounts;
                AtomicInteger newCounter = new AtomicInteger();
                count = concurrentMap.putIfAbsent(ann, newCounter);
                if (count == null) {
                    count = newCounter;
                }
            } else {
                Map<RowAnnotationImpl, AtomicInteger> map = this._rowCounts;
                synchronized (map) {
                    count = this._rowCounts.get(ann);
                    if (count == null) {
                        count = new AtomicInteger();
                        this._rowCounts.put(ann, count);
                    }
                }
            }
        }
        return count;
    }

    @Override
    public final void reset(RowAnnotation annotation) {
        RowAnnotationImpl ann = (RowAnnotationImpl)annotation;
        ann.resetRowCount();
        this._rowCounts.remove(annotation);
        this.resetRows(annotation);
    }

    @Override
    public final RowAnnotation createAnnotation() {
        RowAnnotationImpl ann = new RowAnnotationImpl();
        return ann;
    }

    @Override
    public final Map<Object, Integer> getValueCounts(RowAnnotation annotation, InputColumn<?> inputColumn) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        InputRow[] rows = this.getRows(annotation);
        if (rows == null || rows.length == 0) {
            return map;
        }
        for (InputRow row : rows) {
            Object value = row.getValue(inputColumn);
            Integer count = map.get(value);
            if (count == null) {
                count = 0;
            }
            count = count + this.getDistinctCount(row);
            map.put(value, count);
        }
        return map;
    }

    protected abstract void resetRows(RowAnnotation var1);

    protected abstract int getDistinctCount(InputRow var1);

    protected abstract void storeRowAnnotation(int var1, RowAnnotation var2);

    protected abstract void storeRowValues(int var1, InputRow var2, int var3);

    public final Integer getStoredRowsThreshold() {
        return this._storedRowsThreshold;
    }
}

