/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datacleaner.api.InputRow;
import org.datacleaner.storage.AbstractRowAnnotationFactory;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.RowAnnotationImpl;
import org.datacleaner.util.ImmutableEntry;

public class InMemoryRowAnnotationFactory
extends AbstractRowAnnotationFactory
implements RowAnnotationFactory {
    private static final long serialVersionUID = 1L;
    private final Map<RowAnnotation, Set<Integer>> _annotatedRows = new ConcurrentHashMap<RowAnnotation, Set<Integer>>();
    private final Map<Integer, Map.Entry<InputRow, Integer>> _distinctCounts = new ConcurrentHashMap<Integer, Map.Entry<InputRow, Integer>>();

    public InMemoryRowAnnotationFactory() {
        this(1000);
    }

    public InMemoryRowAnnotationFactory(int storedRowsThreshold) {
        super(storedRowsThreshold);
    }

    protected int getInMemoryRowCount(RowAnnotation annotation) {
        Set<Integer> rows = this._annotatedRows.get(annotation);
        if (rows == null) {
            return 0;
        }
        return rows.size();
    }

    @Override
    protected void resetRows(RowAnnotation annotation) {
        this._annotatedRows.remove(annotation);
    }

    @Override
    protected int getDistinctCount(InputRow row) {
        return this._distinctCounts.get(row.getId()).getValue();
    }

    @Override
    protected void storeRowAnnotation(int rowId, RowAnnotation annotation) {
        Set<Integer> rowIds = this.getRowIds(annotation);
        rowIds.add(rowId);
    }

    private Set<Integer> getRowIds(RowAnnotation annotation) {
        Set<Integer> rowIds = this._annotatedRows.get(annotation);
        if (rowIds == null) {
            rowIds = Collections.synchronizedSet(new LinkedHashSet());
            this._annotatedRows.put(annotation, rowIds);
        }
        return rowIds;
    }

    @Override
    protected void storeRowValues(int rowId, InputRow row, int distinctCount) {
        this._distinctCounts.put(rowId, new ImmutableEntry<InputRow, Integer>(row, distinctCount));
    }

    @Override
    public InputRow[] getRows(RowAnnotation annotation) {
        Set<Integer> rowIds = this._annotatedRows.get(annotation);
        if (rowIds == null) {
            return new InputRow[0];
        }
        InputRow[] rows = new InputRow[rowIds.size()];
        int i = 0;
        for (Integer rowId : rowIds) {
            rows[i] = this._distinctCounts.get(rowId).getKey();
            ++i;
        }
        return rows;
    }

    @Override
    public void transferAnnotations(RowAnnotation from, RowAnnotation to) {
        int rowCountToAdd = from.getRowCount();
        ((RowAnnotationImpl)to).incrementRowCount(rowCountToAdd);
    }
}

