/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datacleaner.storage.InMemoryRowAnnotationFactory;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.StorageProvider;

public final class InMemoryStorageProvider
implements StorageProvider {
    private final int _storedRowsThreshold;

    public InMemoryStorageProvider() {
        this(1000);
    }

    public InMemoryStorageProvider(int storedRowsThreshold) {
        this._storedRowsThreshold = storedRowsThreshold;
    }

    @Override
    public <E> List<E> createList(Class<E> valueType) throws IllegalStateException {
        return new ArrayList();
    }

    @Override
    public <K, V> Map<K, V> createMap(Class<K> keyType, Class<V> valueType) throws IllegalStateException {
        return new HashMap();
    }

    @Override
    public <E> Set<E> createSet(Class<E> valueType) throws IllegalStateException {
        return new HashSet();
    }

    @Override
    public RowAnnotationFactory createRowAnnotationFactory() {
        return new InMemoryRowAnnotationFactory(this._storedRowsThreshold);
    }
}

