/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.storage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.util.ReadObjectBuilder;

public final class RowAnnotationImpl
implements RowAnnotation {
    private static final long serialVersionUID = 1L;
    private final AtomicInteger _counter = new AtomicInteger();

    public void incrementRowCount(int increment) {
        this._counter.addAndGet(increment);
    }

    public void resetRowCount() {
        this._counter.set(0);
    }

    @Override
    public int getRowCount() {
        return this._counter.get();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            Field counterField = this.getClass().getDeclaredField("_counter");
            counterField.setAccessible(true);
            counterField.set(this, new AtomicInteger());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create counter while deserializing.", e);
        }
        ReadObjectBuilder<RowAnnotationImpl> builder = ReadObjectBuilder.create(this, RowAnnotationImpl.class);
        ReadObjectBuilder.Adaptor adaptor = new ReadObjectBuilder.Adaptor(){

            @Override
            public void deserialize(ObjectInputStream.GetField getField, Serializable serializable) throws IOException {
                try {
                    int count = getField.get("_rowCount", 0);
                    RowAnnotationImpl.this._counter.set(count);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        builder.readObject(stream, adaptor);
    }
}

