/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.user;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.datacleaner.user.UserPreferences;
import org.datacleaner.util.SecurityUtils;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.http.CASMonitorHttpClient;
import org.datacleaner.util.http.HttpBasicMonitorHttpClient;
import org.datacleaner.util.http.MonitorHttpClient;
import org.datacleaner.util.http.SimpleWebServiceHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MonitorConnection.class);
    private final String _hostname;
    private final int _port;
    private final String _contextPath;
    private final boolean _https;
    private final String _tenantId;
    private final String _username;
    private final String _encodedPassword;
    private final UserPreferences _userPreferences;
    private transient boolean _acceptUnverifiedSslPeers = false;

    public MonitorConnection(UserPreferences userPreferences, String hostname, int port, String contextPath, boolean isHttps, String tenantId, String username, char[] password) {
        this(userPreferences, hostname, port, contextPath, isHttps, tenantId, username, SecurityUtils.encodePassword(password));
    }

    public MonitorConnection(UserPreferences userPreferences, String hostname, int port, String contextPath, boolean isHttps, String tenantId, String username, String encodedPassword) {
        this._userPreferences = userPreferences;
        this._hostname = hostname;
        this._port = port;
        this._contextPath = this.removeEndingSlash(this.removeBeginningSlash(contextPath));
        this._https = isHttps;
        this._tenantId = tenantId;
        this._username = username;
        this._encodedPassword = encodedPassword;
    }

    public MonitorHttpClient getHttpClient() {
        Object httpClient = this._userPreferences == null ? new DefaultHttpClient() : this._userPreferences.createHttpClient();
        if (this._acceptUnverifiedSslPeers) {
            SecurityUtils.removeSshCertificateChecks((HttpClient)httpClient);
        }
        if (!this.isAuthenticationEnabled()) {
            return new SimpleWebServiceHttpClient((HttpClient)httpClient);
        }
        String password = SecurityUtils.decodePassword(this.getEncodedPassword());
        String username = this.getUsername();
        String securityMode = System.getProperty("datacleaner.monitor.security.mode");
        if ("CAS".equalsIgnoreCase(securityMode)) {
            String casUrl = System.getProperty("datacleaner.monitor.security.casserverurl");
            return new CASMonitorHttpClient((HttpClient)httpClient, casUrl, username, password, this.getBaseUrl());
        }
        return new HttpBasicMonitorHttpClient((HttpClient)httpClient, this.getHostname(), this.getPort(), username, password);
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public boolean isHttps() {
        return this._https;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getEncodedPassword() {
        return this._encodedPassword;
    }

    public String getTenantId() {
        return this._tenantId;
    }

    public String getUsername() {
        return this._username;
    }

    public String getBaseUrl() {
        StringBuilder sb = new StringBuilder();
        if (this._https) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(this._hostname);
        if (this._https && this._port != 443 || !this._https && this._port != 80) {
            sb.append(':');
            sb.append(this._port);
        }
        if (!StringUtils.isNullOrEmpty(this._contextPath)) {
            sb.append('/');
            sb.append(this._contextPath);
        }
        return sb.toString();
    }

    public String getRepositoryUrl() {
        return this.getBaseUrl() + "/repository" + (StringUtils.isNullOrEmpty(this._tenantId) ? "" : "/" + this._tenantId);
    }

    public boolean isAuthenticationEnabled() {
        return !StringUtils.isNullOrEmpty(this._username);
    }

    public boolean matchesURI(String uriString) {
        if (uriString == null) {
            return false;
        }
        try {
            URI uri = new URI(uriString);
            return this.matchesURI(uri);
        }
        catch (URISyntaxException e) {
            logger.debug("Failed to create URI of string: " + uriString, (Throwable)e);
            return false;
        }
    }

    public boolean matchesURI(URI uri) {
        int port;
        if (uri == null) {
            return false;
        }
        String host = uri.getHost();
        if (host.equals(this._hostname) && ((port = uri.getPort()) == this._port || port == -1)) {
            String path = this.removeBeginningSlash(uri.getPath());
            if (StringUtils.isNullOrEmpty(this._contextPath) || path.startsWith(this._contextPath)) {
                return true;
            }
        }
        return false;
    }

    private String removeBeginningSlash(String contextPath) {
        if (contextPath == null) {
            return null;
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return contextPath;
    }

    private String removeEndingSlash(String contextPath) {
        if (contextPath == null) {
            return null;
        }
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    public boolean isAcceptUnverifiedSslPeers() {
        return this._acceptUnverifiedSslPeers;
    }

    public void setAcceptUnverifiedSslPeers(boolean acceptUnverifiedSslPeers) {
        this._acceptUnverifiedSslPeers = acceptUnverifiedSslPeers;
    }
}

