/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.metamodel.util.EqualsBuilder;
import org.apache.metamodel.util.LegacyDeserializationObjectInputStream;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.AnalyzerResultReducer;
import org.datacleaner.api.ComponentCategory;
import org.datacleaner.api.HasAnalyzerResult;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.Metric;
import org.datacleaner.api.Renderable;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.SchemaNavigator;
import org.datacleaner.descriptors.MetricDescriptor;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ImmutableComponentConfiguration;
import org.datacleaner.reference.TextFileDictionary;
import org.datacleaner.reference.TextFileSynonymCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeAwareObjectInputStream
extends LegacyDeserializationObjectInputStream {
    private static final Logger logger = LoggerFactory.getLogger(ChangeAwareObjectInputStream.class);
    private static final Map<String, Class<?>> PRIMITIVE_CLASSES = new HashMap(8, 1.0f);
    private static final Set<String> INTERFACES_WITH_SERIAL_ID_CHANGES = new HashSet<String>();
    private static final Comparator<String> packageNameComparator;
    private final List<ClassLoader> additionalClassLoaders;
    private final Map<String, String> renamedPackages = new TreeMap<String, String>(packageNameComparator);
    private final Map<String, String> renamedClasses = new HashMap<String, String>();

    public ChangeAwareObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.additionalClassLoaders = new ArrayList<ClassLoader>();
        this.addRenamedClass("org.datacleaner.reference.TextBasedDictionary", TextFileDictionary.class);
        this.addRenamedClass("org.datacleaner.reference.TextBasedSynonymCatalog", TextFileSynonymCatalog.class);
        this.addRenamedClass("org.datacleaner.result.PatternFinderResult", "org.datacleaner.beans.stringpattern.PatternFinderResult");
        this.addRenamedClass("org.datacleaner.result.DateGapAnalyzerResult", "org.datacleaner.beans.dategap.DateGapAnalyzerResult");
        this.addRenamedClass("org.datacleaner.util.TimeInterval", "org.datacleaner.beans.dategap.TimeInterval");
        this.addRenamedClass("org.datacleaner.result.StringAnalyzerResult", "org.datacleaner.beans.StringAnalyzerResult");
        this.addRenamedClass("org.datacleaner.result.NumberAnalyzerResult", "org.datacleaner.beans.NumberAnalyzerResult");
        this.addRenamedClass("org.datacleaner.result.BooleanAnalyzerResult", "org.datacleaner.beans.BooleanAnalyzerResult");
        this.addRenamedClass("org.datacleaner.result.DateAndTimeAnalyzerResult", "org.datacleaner.beans.DateAndTimeAnalyzerResult");
        this.addRenamedClass("org.datacleaner.result.ValueDistributionGroupResult", "org.datacleaner.beans.valuedist.SingleValueDistributionResult");
        this.addRenamedClass("org.datacleaner.result.ValueDistributionResult", "org.datacleaner.beans.valuedist.GroupedValueDistributionResult");
        this.addRenamedClass("org.datacleaner.beans.valuedist.ValueDistributionGroupResult", "org.datacleaner.beans.valuedist.SingleValueDistributionResult");
        this.addRenamedClass("org.datacleaner.beans.valuedist.ValueDistributionResult", "org.datacleaner.beans.valuedist.GroupedValueDistributionResult");
        this.addRenamedClass("org.datacleaner.beans.valuedist.ValueCount", "org.datacleaner.result.SingleValueFrequency");
        this.addRenamedClass("org.datacleaner.result.ValueCount", "org.datacleaner.result.SingleValueFrequency");
        this.addRenamedClass("org.datacleaner.beans.valuedist.ValueCountList", "org.datacleaner.result.ValueCountList");
        this.addRenamedClass("org.datacleaner.beans.valuedist.ValueCountListImpl", "org.datacleaner.result.ValueCountListImpl");
        this.addRenamedClass("com.hi.contacts.datacleaner.DuplicateDetectionAnalyzer", "com.hi.hiqmr.datacleaner.deduplication.Identify7DeduplicationAnalyzer");
        this.addRenamedClass("org.datacleaner.data.InputRow", InputRow.class);
        this.addRenamedClass("org.datacleaner.data.InputColumn", InputColumn.class);
        this.addRenamedClass("org.datacleaner.result.Metric", Metric.class);
        this.addRenamedClass("org.datacleaner.job.BeanConfiguration", ComponentConfiguration.class);
        this.addRenamedClass("org.datacleaner.job.ImmutableBeanConfiguration", ImmutableComponentConfiguration.class);
        this.addRenamedClass("org.datacleaner.descriptors.AnnotationBasedAnalyzerBeanDescriptor", "org.datacleaner.descriptors.AnnotationBasedAnalyzerComponentDescriptor");
        this.addRenamedClass("org.datacleaner.descriptors.AnnotationBasedTransformerBeanDescriptor", "org.datacleaner.descriptors.AnnotationBasedTransformerComponentDescriptor");
        this.addRenamedClass("org.datacleaner.descriptors.AnnotationBasedFilterBeanDescriptor", "org.datacleaner.descriptors.AnnotationBasedFilterComponentDescriptor");
        this.addRenamedClass("org.datacleaner.descriptors.AbstractHasAnalyzerResultBeanDescriptor", "org.datacleaner.descriptors.AbstractHasAnalyzerResultComponentDescriptor");
        this.addRenamedClass("org.datacleaner.descriptors.AbstractBeanDescriptor", "org.datacleaner.descriptors.AbstractComponentDescriptor");
        this.addRenamedClass("org.eobjects.analyzer.result.AnalyzerResult", AnalyzerResult.class);
        this.addRenamedClass("org.eobjects.analyzer.result.AnalyzerResultReducer", AnalyzerResultReducer.class);
        this.addRenamedClass("org.eobjects.analyzer.result.HasAnalyzerResult", HasAnalyzerResult.class);
        this.addRenamedClass("org.eobjects.analyzer.result.Metric", Metric.class);
        this.addRenamedClass("org.eobjects.analyzer.result.renderer.Renderable", Renderable.class);
        this.addRenamedClass("org.eobjects.analyzer.util.SchemaNavigator", SchemaNavigator.class);
        this.addRenamedPackage("org.eobjects.datacleaner", "org.datacleaner");
        this.addRenamedPackage("org.eobjects.analyzer", "org.datacleaner");
        this.addRenamedPackage("org.datacleaner.beans.api", "org.datacleaner.api");
        this.addRenamedPackage("org.datacleaner.beans.categories", "org.datacleaner.components.categories");
        this.addRenamedPackage("org.eobjects.metamodel", "org.apache.metamodel");
        this.addRenamedPackage("org.datacleaner.output.beans", "org.datacleaner.extension.output");
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.additionalClassLoaders.add(classLoader);
    }

    public void addRenamedPackage(String originalPackageName, String newPackageName) {
        this.renamedPackages.put(originalPackageName, newPackageName);
    }

    public void addRenamedClass(String originalClassName, Class<?> newClass) {
        this.addRenamedClass(originalClassName, newClass.getName());
    }

    public void addRenamedClass(String originalClassName, String newClassName) {
        this.renamedClasses.put(originalClassName, newClassName);
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
        String originalClassName = resultClassDescriptor.getName();
        String className = this.getClassNameRenamed(originalClassName);
        if (className != originalClassName) {
            return this.getClassDescriptor(className, false, resultClassDescriptor);
        }
        if (INTERFACES_WITH_SERIAL_ID_CHANGES.contains(originalClassName)) {
            ObjectStreamClass newClassDescriptor = ObjectStreamClass.lookup(this.resolveClass(originalClassName, false));
            return newClassDescriptor;
        }
        return resultClassDescriptor;
    }

    private ObjectStreamClass getClassDescriptor(String className, boolean checkRenames, ObjectStreamClass originalClassDescriptor) throws ClassNotFoundException {
        Class<?> newClass;
        ObjectStreamClass newClassDescriptor;
        if (originalClassDescriptor == null) {
            logger.warn("Original ClassDescriptor resolved to null for '{}'", (Object)className);
        }
        if ((newClassDescriptor = ObjectStreamClass.lookupAny(newClass = this.resolveClass(className, checkRenames))) == null) {
            logger.warn("New ClassDescriptor resolved to null for {}", newClass);
        }
        String[] newFieldNames = this.getFieldNames(newClassDescriptor);
        String[] originalFieldNames = this.getFieldNames(originalClassDescriptor);
        if (!EqualsBuilder.equals((Object)originalFieldNames, (Object)newFieldNames)) {
            logger.warn("Field names of original and new class ({}) does not correspond!", (Object)className);
            try {
                Field field = ObjectStreamClass.class.getDeclaredField("name");
                assert (field != null);
                assert (field.getType() == String.class);
                field.setAccessible(true);
                field.set(originalClassDescriptor, className);
                return originalClassDescriptor;
            }
            catch (Exception e) {
                logger.error("Unsuccesful attempt at changing the name of the original class descriptor");
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return newClassDescriptor;
    }

    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        if (className.startsWith("org.eobjects.metamodel") || className.startsWith("[Lorg.eobjects.metamodel")) {
            return super.resolveClass(desc);
        }
        return this.resolveClass(className, true);
    }

    private Class<?> resolveClass(String classNameParameter, boolean checkRenames) throws ClassNotFoundException {
        logger.debug("Resolving class '{}'", (Object)classNameParameter);
        String className = checkRenames ? this.getClassNameRenamed(classNameParameter) : classNameParameter;
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Class<?> primitiveClass = PRIMITIVE_CLASSES.get(className);
            if (primitiveClass != null) {
                return primitiveClass;
            }
            logger.info("Class '{}' was not resolved in main class loader.", (Object)className);
            ArrayList<ClassNotFoundException> exceptions = new ArrayList<ClassNotFoundException>(this.additionalClassLoaders.size());
            for (ClassLoader classLoader : this.additionalClassLoaders) {
                try {
                    return Class.forName(className, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.info("Class '{}' was not resolved in additional class loader '{}'", (Object)className, (Object)classLoader);
                    exceptions.add(classNotFoundException);
                }
            }
            logger.warn("Could not resolve class of name '{}'", (Object)className);
            int i = 1;
            for (Exception exception : exceptions) {
                int numExceptions = exceptions.size();
                logger.error("Exception " + i + " of " + numExceptions, (Throwable)exception);
                ++i;
            }
            throw e;
        }
    }

    private String getClassNameRenamed(String className) {
        return this.getClassNameRenamed(className, true);
    }

    private String getClassNameRenamed(String className, boolean includeRenamedPackages) {
        if (className.startsWith("[L")) {
            String classNameWithoutArrayDef = className.substring(2, className.length() - 1);
            return "[L" + this.getClassNameRenamed(classNameWithoutArrayDef) + ";";
        }
        String directlyRenamedClassName = this.renamedClasses.get(className);
        if (directlyRenamedClassName != null) {
            logger.info("Class '{}' was encountered. Returning new class name: '{}'", (Object)className, (Object)directlyRenamedClassName);
            return directlyRenamedClassName;
        }
        if (includeRenamedPackages) {
            Set<Map.Entry<String, String>> entrySet = this.renamedPackages.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String legacyPackage = entry.getKey();
                if (!className.startsWith(legacyPackage)) continue;
                String renamedClassName = className.replaceFirst(legacyPackage, entry.getValue());
                logger.info("Class '{}' was encountered. Adapting to new class name: '{}'", (Object)className, (Object)renamedClassName);
                return this.getClassNameRenamed(renamedClassName, includeRenamedPackages);
            }
        }
        return className;
    }

    private String[] getFieldNames(ObjectStreamClass classDescriptor) {
        if (classDescriptor == null) {
            return new String[0];
        }
        ObjectStreamField[] fields = classDescriptor.getFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
        INTERFACES_WITH_SERIAL_ID_CHANGES.add(InputColumn.class.getName());
        INTERFACES_WITH_SERIAL_ID_CHANGES.add(ComponentJob.class.getName());
        INTERFACES_WITH_SERIAL_ID_CHANGES.add(Datastore.class.getName());
        INTERFACES_WITH_SERIAL_ID_CHANGES.add(MetricDescriptor.class.getName());
        INTERFACES_WITH_SERIAL_ID_CHANGES.add(PropertyDescriptor.class.getName());
        INTERFACES_WITH_SERIAL_ID_CHANGES.add(ComponentCategory.class.getName());
        INTERFACES_WITH_SERIAL_ID_CHANGES.add("org.datacleaner.beans.writers.WriteDataResult");
        packageNameComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (EqualsBuilder.equals((Object)o1, (Object)o2)) {
                    return 0;
                }
                int diff = o1.length() - o2.length();
                if (diff == 0) {
                    diff = o1.compareTo(o2);
                }
                return diff;
            }
        };
    }
}

