/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class ExtensionFilter
extends FileFilter
implements FilenameFilter {
    private final String _desc;
    private final String _extension;
    private final boolean _includeDirectories;

    public ExtensionFilter(String desc, String extension) {
        this(desc, extension, true);
    }

    public ExtensionFilter(String desc, String extension, boolean includeDirectories) {
        this._includeDirectories = includeDirectories;
        this._desc = desc;
        this._extension = extension.toLowerCase();
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return this._includeDirectories;
        }
        String fileName = f.getAbsolutePath();
        if (fileName.length() < this._extension.length()) {
            return false;
        }
        return this.accept(null, fileName);
    }

    @Override
    public boolean accept(File dir, String name) {
        int startIndex = name.length() - this._extension.length();
        if (startIndex < 0) {
            return false;
        }
        String extension = name.substring(startIndex);
        return extension.equalsIgnoreCase(this._extension);
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    public String getExtension() {
        return this._extension;
    }
}

