/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.metamodel.schema.Column;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.TransformedInputColumn;

public class InputColumnComparator
implements Comparator<InputColumn<?>>,
Serializable {
    private static final long serialVersionUID = 1L;

    public static int compareInputColumns(InputColumn<?> o1, InputColumn<?> o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.isPhysicalColumn() && o2.isPhysicalColumn()) {
            Column physicalColumn1 = o1.getPhysicalColumn();
            Column physicalColumn2 = o2.getPhysicalColumn();
            int result = physicalColumn1.getColumnNumber() - physicalColumn2.getColumnNumber();
            if (result == 0) {
                result = physicalColumn1.compareTo((Object)physicalColumn2);
            }
            return result;
        }
        if (o1.isVirtualColumn() && o2.isVirtualColumn()) {
            if (o1 instanceof TransformedInputColumn && o2 instanceof TransformedInputColumn) {
                TransformedInputColumn col1 = (TransformedInputColumn)o1;
                TransformedInputColumn col2 = (TransformedInputColumn)o2;
                String id1 = col1.getId();
                String id2 = col2.getId();
                return id1.compareTo(id2);
            }
            int result = o1.getName().compareTo(o2.getName());
            if (result == 0) {
                result = o1.hashCode() - o2.hashCode();
            }
            return result;
        }
        if (o1.isPhysicalColumn() && o2.isVirtualColumn()) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compare(InputColumn<?> o1, InputColumn<?> o2) {
        return InputColumnComparator.compareInputColumns(o1, o2);
    }
}

