/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.datacleaner.api.Component;
import org.datacleaner.api.HasLabelAdvice;
import org.datacleaner.api.InputColumn;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.AnyComponentRequirement;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.builder.ComponentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LabelUtils {
    private static final Logger logger = LoggerFactory.getLogger(LabelUtils.class);
    public static final String NULL_LABEL = "<null>";
    public static final String UNIQUE_LABEL = "<unique>";
    public static final String BLANK_LABEL = "<blank>";
    public static final String UNEXPECTED_LABEL = "<unexpected>";
    public static final String COUNT_LABEL = "COUNT(*)";

    private LabelUtils() {
    }

    public static String getLabel(ComponentBuilder builder) {
        String suggestedLabel;
        String name = builder.getName();
        if (!Strings.isNullOrEmpty((String)name)) {
            return name;
        }
        Component componentInstance = builder.getComponentInstance();
        if (componentInstance != null && componentInstance instanceof HasLabelAdvice && !Strings.isNullOrEmpty((String)(suggestedLabel = ((HasLabelAdvice)componentInstance).getSuggestedLabel()))) {
            return suggestedLabel;
        }
        String descriptorDisplayName = builder.getDescriptor().getDisplayName();
        return descriptorDisplayName;
    }

    public static String getLabel(ComponentJob job) {
        return LabelUtils.getLabel(job, false, true, true);
    }

    public static String getLabel(ComponentJob job, boolean includeDescriptorName, boolean includeInputColumnNames, boolean includeRequirements) {
        String jobName = job.getName();
        StringBuilder label = new StringBuilder();
        if (Strings.isNullOrEmpty((String)jobName)) {
            ComponentDescriptor descriptor = job.getDescriptor();
            label.append(descriptor.getDisplayName());
        } else {
            label.append(jobName);
        }
        if (job instanceof AnalyzerJob) {
            InputColumn[] input;
            AnalyzerJob analyzerJob = (AnalyzerJob)job;
            if (includeDescriptorName && !Strings.isNullOrEmpty((String)jobName)) {
                label.append(" (");
                label.append(analyzerJob.getDescriptor().getDisplayName());
                label.append(')');
            }
            if ((input = analyzerJob.getInput()).length == 1 && input[0].getName().equals(jobName)) {
                includeInputColumnNames = false;
            }
            if (includeInputColumnNames && input.length > 0) {
                label.append(" (");
                if (input.length < 5) {
                    for (int i = 0; i < input.length; ++i) {
                        if (i != 0) {
                            label.append(',');
                        }
                        label.append(input[i].getName());
                    }
                } else {
                    label.append(input.length);
                    label.append(" columns");
                }
                label.append(")");
            }
            ComponentRequirement requirement = analyzerJob.getComponentRequirement();
            if (includeRequirements && requirement != null && !(requirement instanceof AnyComponentRequirement)) {
                label.append(" (");
                label.append(requirement.toString());
                label.append(")");
            }
        }
        return label.toString();
    }

    public static String getLabel(String text) {
        if (text == null) {
            return NULL_LABEL;
        }
        if ("".equals(text)) {
            return BLANK_LABEL;
        }
        return text;
    }

    public static String getDataTypeLabel(Class<?> dataType) {
        if (dataType == null) {
            return "<undefined>";
        }
        return dataType.getSimpleName();
    }

    public static String getValueLabel(Object value) {
        Format format;
        String suggestedLabel;
        if (value == null) {
            return NULL_LABEL;
        }
        if (value instanceof HasLabelAdvice && !Strings.isNullOrEmpty((String)(suggestedLabel = ((HasLabelAdvice)value).getSuggestedLabel()))) {
            return suggestedLabel;
        }
        if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
            format = NumberFormat.getNumberInstance();
            String result = format.format((Number)value);
            logger.debug("Formatted decimal {} to: {}", value, (Object)result);
            return result;
        }
        if (value instanceof Date) {
            format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String result = ((DateFormat)format).format((Date)value);
            logger.debug("Formatted date {} to: {}", value, (Object)result);
            return result;
        }
        return LabelUtils.getLabel(value.toString());
    }
}

