/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class ProgressCounter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int _significantUpdateIntervalMillis;
    private final AtomicInteger _value = new AtomicInteger(0);
    private volatile transient long _lastUpdate = -1L;

    public ProgressCounter(int significantUpdateIntervalMillis) {
        this._significantUpdateIntervalMillis = significantUpdateIntervalMillis;
    }

    public ProgressCounter() {
        this(2000);
    }

    public int get() {
        return this._value.get();
    }

    public boolean setIfSignificantToUser(int newValue) {
        int currentValue;
        while (newValue > (currentValue = this._value.get())) {
            long currentTimestamp;
            if (this._significantUpdateIntervalMillis > 0) {
                currentTimestamp = System.currentTimeMillis();
                if (currentTimestamp - this._lastUpdate < (long)this._significantUpdateIntervalMillis) {
                    return false;
                }
            } else {
                currentTimestamp = -1L;
            }
            if (!this._value.compareAndSet(currentValue, newValue)) continue;
            this._lastUpdate = currentTimestamp;
            return true;
        }
        return false;
    }
}

