/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.ExpressionBasedInputColumn;
import org.datacleaner.api.InputColumn;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.InputColumnSinkJob;
import org.datacleaner.job.InputColumnSourceJob;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.SourceColumns;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceColumnFinder {
    private static final String LOG_MESSAGE_RECURSIVE_TRAVERSAL = "Ending traversal of object graph because the same originating objects are appearing recursively";
    private static final Logger logger = LoggerFactory.getLogger(SourceColumnFinder.class);
    private Set<InputColumnSinkJob> _inputColumnSinks = new HashSet<InputColumnSinkJob>();
    private Set<InputColumnSourceJob> _inputColumnSources = new LinkedHashSet<InputColumnSourceJob>();
    private Set<HasFilterOutcomes> _outcomeSources = new HashSet<HasFilterOutcomes>();
    private Set<HasComponentRequirement> _outcomeSinks = new HashSet<HasComponentRequirement>();

    private void addSources(Object ... sources) {
        for (Object source : sources) {
            if (source instanceof InputColumnSinkJob) {
                this._inputColumnSinks.add((InputColumnSinkJob)source);
            }
            if (source instanceof InputColumnSourceJob) {
                this._inputColumnSources.add((InputColumnSourceJob)source);
            }
            if (source instanceof HasFilterOutcomes) {
                this._outcomeSources.add((HasFilterOutcomes)source);
            }
            if (!(source instanceof HasComponentRequirement)) continue;
            this._outcomeSinks.add((HasComponentRequirement)source);
        }
    }

    private void addSources(Collection<?> sources) {
        this.addSources(sources.toArray());
    }

    public void addSources(AnalysisJobBuilder job) {
        this.addSources(new SourceColumns(job.getSourceColumns()));
        this.addSources(job.getFilterComponentBuilders());
        this.addSources(job.getTransformerComponentBuilders());
        this.addSources(job.getAnalyzerComponentBuilders());
    }

    public void addSources(AnalysisJob job) {
        this.addSources(new SourceColumns(job.getSourceColumns()));
        this.addSources(job.getFilterJobs());
        this.addSources(job.getTransformerJobs());
        this.addSources(job.getAnalyzerJobs());
    }

    public List<InputColumn<?>> findInputColumns(Class<?> dataType) {
        ArrayList result = new ArrayList();
        for (InputColumnSourceJob source : this._inputColumnSources) {
            InputColumn[] outputColumns;
            for (InputColumn col : outputColumns = source.getOutput()) {
                Class columnDataType = col.getDataType();
                if (dataType == null || columnDataType == null) {
                    result.add(col);
                    continue;
                }
                if (!ReflectionUtils.is(columnDataType, dataType)) continue;
                result.add(col);
            }
        }
        return result;
    }

    public Set<Object> findAllSourceJobs(Object job) {
        HashSet<Object> result = new HashSet<Object>();
        this.findAllSourceJobs(job, result);
        return result;
    }

    private void findAllSourceJobs(Object job, Set<Object> result) {
        if (job == null) {
            return;
        }
        if (job instanceof InputColumnSinkJob) {
            InputColumn[] inputColumns = ((InputColumnSinkJob)job).getInput();
            for (InputColumn inputColumn : inputColumns) {
                boolean added;
                InputColumnSourceJob source = this.findInputColumnSource(inputColumn);
                if (source == null || !(added = result.add(source))) continue;
                this.findAllSourceJobs(source, result);
            }
        }
        if (job instanceof HasComponentRequirement) {
            HasComponentRequirement hasComponentRequirement = (HasComponentRequirement)job;
            ComponentRequirement requirement = hasComponentRequirement.getComponentRequirement();
            this.findAllSourceJobs(requirement, result);
        }
        if (job instanceof ComponentRequirement) {
            Collection<FilterOutcome> requirements = this.getProcessingDependencies((ComponentRequirement)job);
            for (FilterOutcome outcome : requirements) {
                boolean added;
                HasFilterOutcomes source = this.findOutcomeSource(outcome);
                if (source == null || !(added = result.add(source))) continue;
                this.findAllSourceJobs(source, result);
            }
        }
    }

    public InputColumnSourceJob findInputColumnSource(InputColumn<?> inputColumn) {
        if (inputColumn instanceof ExpressionBasedInputColumn) {
            return null;
        }
        for (InputColumnSourceJob source : this._inputColumnSources) {
            InputColumn[] output;
            for (InputColumn column : output = source.getOutput()) {
                if (!inputColumn.equals((Object)column)) continue;
                return source;
            }
        }
        return null;
    }

    public HasFilterOutcomes findOutcomeSource(FilterOutcome requirement) {
        for (HasFilterOutcomes source : this._outcomeSources) {
            Collection outcomes = source.getFilterOutcomes();
            for (FilterOutcome outcome : outcomes) {
                if (!requirement.equals(outcome)) continue;
                return source;
            }
        }
        return null;
    }

    public Set<Column> findOriginatingColumns(FilterOutcome requirement) {
        HasFilterOutcomes source = this.findOutcomeSource(requirement);
        HashSet<Column> result = new HashSet<Column>();
        this.findOriginatingColumnsOfSource(source, result);
        return result;
    }

    public Table findOriginatingTable(FilterOutcome requirement) {
        return this.findOriginatingTable(requirement, new HashSet<Object>());
    }

    private Table findOriginatingTable(FilterOutcome requirement, Set<Object> resolvedSet) {
        HasFilterOutcomes source = this.findOutcomeSource(requirement);
        if (!resolvedSet.add(source)) {
            logger.debug(LOG_MESSAGE_RECURSIVE_TRAVERSAL);
            return null;
        }
        return this.findOriginatingTableOfSource(source, resolvedSet);
    }

    public Table findOriginatingTable(InputColumn<?> inputColumn) {
        return this.findOriginatingTable(inputColumn, new HashSet<Object>());
    }

    private Table findOriginatingTable(InputColumn<?> inputColumn, Set<Object> resolvedSet) {
        if (!resolvedSet.add(inputColumn)) {
            logger.debug(LOG_MESSAGE_RECURSIVE_TRAVERSAL);
            return null;
        }
        if (inputColumn == null) {
            logger.warn("InputColumn was null, no originating table found");
            return null;
        }
        if (inputColumn.isPhysicalColumn()) {
            return inputColumn.getPhysicalColumn().getTable();
        }
        InputColumnSourceJob inputColumnSource = this.findInputColumnSource(inputColumn);
        if (!resolvedSet.add(inputColumnSource)) {
            logger.debug(LOG_MESSAGE_RECURSIVE_TRAVERSAL);
            return null;
        }
        return this.findOriginatingTableOfSource(inputColumnSource, resolvedSet);
    }

    private Table findOriginatingTableOfSource(Object source, Set<Object> resolvedSet) {
        Table table;
        InputColumn[] input;
        TreeSet<Table> result = new TreeSet<Table>();
        if (source instanceof InputColumnSinkJob && (input = ((InputColumnSinkJob)source).getInput()) != null) {
            for (InputColumn col : input) {
                if (col == null) {
                    logger.warn("InputColumn sink had a null-column element!");
                    continue;
                }
                table = this.findOriginatingTable(col, resolvedSet);
                if (table == null) continue;
                result.add(table);
            }
        }
        if (source instanceof HasComponentRequirement) {
            HasComponentRequirement hasComponentRequirement = (HasComponentRequirement)source;
            ComponentRequirement componentRequirement = hasComponentRequirement.getComponentRequirement();
            Collection<FilterOutcome> requirements = this.getProcessingDependencies(componentRequirement);
            for (FilterOutcome outcome : requirements) {
                table = this.findOriginatingTable(outcome, resolvedSet);
                if (table == null) continue;
                result.add(table);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return (Table)result.iterator().next();
        }
        StringBuilder sb = new StringBuilder();
        for (Table table2 : result) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(table2.getName());
        }
        throw new IllegalStateException("Multiple originating tables (" + sb + ") found for source: " + source);
    }

    private void findOriginatingColumnsOfInputColumn(InputColumn<?> inputColumn, Set<Column> result) {
        if (inputColumn == null) {
            return;
        }
        if (inputColumn.isPhysicalColumn()) {
            result.add(inputColumn.getPhysicalColumn());
        } else {
            InputColumnSourceJob source = this.findInputColumnSource(inputColumn);
            this.findOriginatingColumnsOfSource(source, result);
        }
    }

    private void findOriginatingColumnsOfOutcome(FilterOutcome requirement, Set<Column> result) {
        HasFilterOutcomes source = this.findOutcomeSource(requirement);
        this.findOriginatingColumnsOfSource(source, result);
    }

    private void findOriginatingColumnsOfSource(Object source, Set<Column> result) {
        InputColumn[] input;
        if (source == null) {
            return;
        }
        if (source instanceof InputColumnSinkJob && (input = ((InputColumnSinkJob)source).getInput()) != null) {
            for (InputColumn inputColumn : input) {
                this.findOriginatingColumnsOfInputColumn(inputColumn, result);
            }
        }
        if (source instanceof HasComponentRequirement) {
            HasComponentRequirement hasComponentRequirement = (HasComponentRequirement)source;
            ComponentRequirement componentRequirement = hasComponentRequirement.getComponentRequirement();
            Collection<FilterOutcome> requirements = this.getProcessingDependencies(componentRequirement);
            for (FilterOutcome outcome : requirements) {
                this.findOriginatingColumnsOfOutcome(outcome, result);
            }
        }
    }

    private Collection<FilterOutcome> getProcessingDependencies(ComponentRequirement componentRequirement) {
        if (componentRequirement == null) {
            return Collections.emptyList();
        }
        Collection processingDependencies = componentRequirement.getProcessingDependencies();
        if (processingDependencies == null) {
            return Collections.emptyList();
        }
        return processingDependencies;
    }

    public Set<Column> findOriginatingColumns(InputColumn<?> inputColumn) {
        HashSet<Column> result = new HashSet<Column>();
        this.findOriginatingColumnsOfInputColumn(inputColumn, result);
        return result;
    }
}

