/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[\\s\\p{Zs}\\p{javaWhitespace}]+");
    public static final String LATIN_CHARACTERS = "";

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isDiacritic(char c) {
        if (Character.isLetter(c)) {
            return !StringUtils.isLatin(c);
        }
        return false;
    }

    public static boolean isLatin(char c) {
        return c >= 'A' && c <= 'z';
    }

    public static String leftTrim(String str) {
        int i;
        for (i = 0; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
        }
        return str.substring(i);
    }

    public static String rightTrim(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && Character.isWhitespace(str.charAt(i)); --i) {
        }
        return str.substring(0, i + 1);
    }

    public static String replaceWhitespaces(String inString, String with) {
        return WHITESPACE_PATTERN.matcher(inString).replaceAll(with);
    }

    public static int indexOf(char c, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (c != chars[i]) continue;
            return i;
        }
        return -1;
    }

    public static String toCamelCase(String name) {
        if (name == null) {
            return name;
        }
        Matcher matcher = WHITESPACE_PATTERN.matcher(name = name.trim());
        if (!matcher.find()) {
            return name;
        }
        int indexOfWhitespace = matcher.start();
        if (indexOfWhitespace == -1) {
            return name;
        }
        String substring1 = name.substring(0, indexOfWhitespace);
        String substring2 = name.substring(indexOfWhitespace + 1);
        substring2 = Character.toUpperCase(substring2.charAt(0)) + substring2.substring(1);
        name = substring1 + substring2;
        return StringUtils.toCamelCase(name);
    }

    public static String getLongestCommonToken(Iterable<String> iterable, char tokenSeparatorChar) {
        Iterator<String> it = iterable.iterator();
        String commonToken = it.next();
        while (it.hasNext()) {
            if (commonToken == LATIN_CHARACTERS) {
                return null;
            }
            String name = it.next();
            if (name.startsWith(commonToken)) continue;
            commonToken = StringUtils.getLongestCommonToken(commonToken, name, tokenSeparatorChar);
        }
        return commonToken;
    }

    public static String getLongestCommonToken(String str1, String str2, char tokenSeparatorChar) {
        StringBuilder result = new StringBuilder();
        String[] tokens1 = str1.split("\\" + tokenSeparatorChar);
        String[] tokens2 = str2.split("\\" + tokenSeparatorChar);
        for (int i = 0; i < Math.min(tokens1.length, tokens2.length) && tokens1[i].equals(tokens2[i]); ++i) {
            if (i != 0) {
                result.append(tokenSeparatorChar);
            }
            result.append(tokens1[i]);
        }
        return result.toString();
    }

    public static String replaceAll(String v, String searchToken, String replacement) {
        if (v == null) {
            return v;
        }
        while (v.indexOf(searchToken) != -1) {
            v = v.replace(searchToken, replacement);
        }
        return v;
    }
}

