/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import com.google.common.base.Strings;

public class SystemProperties {
    public static final String UI_VISIBLE = "datacleaner.ui.visible";
    public static final String UI_DESKTOP_WELCOME_PANEL = "datacleaner.ui.desktop.panel";
    public static final String EMBED_CLIENT = "datacleaner.embed.client";
    public static final String SANDBOX = "datacleaner.sandbox";
    public static final String LICENSE_KEY = "datacleaner.license.key";
    public static final String EDITION_NAME = "datacleaner.edition.name";
    public static final String MONITOR_HOSTNAME = "datacleaner.monitor.hostname";
    public static final String MONITOR_PORT = "datacleaner.monitor.port";
    public static final String MONITOR_CONTEXT = "datacleaner.monitor.context";
    public static final String MONITOR_TENANT = "datacleaner.monitor.tenant";
    public static final String MONITOR_HTTPS = "datacleaner.monitor.https";
    public static final String MONITOR_USERNAME = "datacleaner.monitor.username";
    public static final String MONITOR_SECURITY_MODE = "datacleaner.monitor.security.mode";
    public static final String MONITOR_CAS_URL = "datacleaner.monitor.security.casserverurl";
    public static final String MONITOR_LOG_ROWCOUNT = "datacleaner.userlog.rowcount";
    public static final String QUERY_SELECTCLAUSE_OPTIMIZE = "datacleaner.query.selectclause.optimize";

    public static String getString(String key, String valueIfNull) {
        String value = System.getProperty(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return valueIfNull;
        }
        return value;
    }

    public static long getLong(String key, long valueIfNullOrNotParseable) {
        String value = System.getProperty(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return valueIfNullOrNotParseable;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return valueIfNullOrNotParseable;
        }
    }

    public static long getInt(String key, int valueIfNullOrNotParseable) {
        String value = System.getProperty(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return valueIfNullOrNotParseable;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return valueIfNullOrNotParseable;
        }
    }

    public static boolean getBoolean(String key, boolean valueIfNull) {
        String value = System.getProperty(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return valueIfNull;
        }
        if ("true".equals(value = value.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        return valueIfNull;
    }
}

