/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsResource
implements Resource {
    private static final Logger logger = LoggerFactory.getLogger(VfsResource.class);
    private final FileObject _fileObject;

    public VfsResource(FileObject fileObject) {
        this._fileObject = fileObject;
    }

    public String toString() {
        return "VfsResource[" + this._fileObject + "]";
    }

    public FileObject getFileObject() {
        return this._fileObject;
    }

    public String getName() {
        return this._fileObject.getName().getBaseName();
    }

    public boolean isReadOnly() {
        try {
            return !this._fileObject.isWriteable();
        }
        catch (FileSystemException e) {
            throw new ResourceException((Resource)this, (Exception)((Object)e));
        }
    }

    public boolean isExists() {
        try {
            return this._fileObject.exists();
        }
        catch (FileSystemException e) {
            throw new ResourceException((Resource)this, (Exception)((Object)e));
        }
    }

    public String getQualifiedPath() {
        return this._fileObject.getName().getURI();
    }

    public long getSize() {
        try {
            return this._fileObject.getContent().getSize();
        }
        catch (FileSystemException e) {
            throw new ResourceException((Resource)this, (Exception)((Object)e));
        }
    }

    public long getLastModified() {
        try {
            long lastModified = this._fileObject.getContent().getLastModifiedTime();
            if (lastModified == 0L) {
                return -1L;
            }
            return lastModified;
        }
        catch (FileSystemException e) {
            logger.warn("Failed to get lastModifiedTime of file object: " + this._fileObject + ". Returning -1.", (Throwable)e);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Action<OutputStream> writeCallback) throws ResourceException {
        try {
            FileContent content = this._fileObject.getContent();
            OutputStream out = content.getOutputStream();
            try {
                writeCallback.run((Object)out);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{out});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{out});
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Action<OutputStream> appendCallback) throws ResourceException {
        try {
            FileContent content = this._fileObject.getContent();
            OutputStream out = content.getOutputStream(true);
            try {
                appendCallback.run((Object)out);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{out});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{out});
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }

    public InputStream read() throws ResourceException {
        try {
            return this._fileObject.getContent().getInputStream();
        }
        catch (FileSystemException e) {
            throw new ResourceException((Resource)this, (Exception)((Object)e));
        }
    }

    public void read(Action<InputStream> readCallback) throws ResourceException {
        try {
            InputStream in = this._fileObject.getContent().getInputStream();
            try {
                readCallback.run((Object)in);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{in});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{in});
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E> E read(Func<InputStream, E> readCallback) throws ResourceException {
        try {
            Object object;
            InputStream in = this._fileObject.getContent().getInputStream();
            try {
                Object result;
                object = result = readCallback.eval((Object)in);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{in});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{in});
            return (E)object;
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }
}

