/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.batch;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.util.batch.ArrayBatchSource;
import org.datacleaner.util.batch.BatchEntry;
import org.datacleaner.util.batch.BatchEntryBatchSink;
import org.datacleaner.util.batch.BatchTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTransformationBuffer<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(BatchTransformationBuffer.class);
    public static final int DEFAULT_FLUSH_INTERVAL = 1000;
    public static final int DEFAULT_MAX_BATCH_SIZE = 20;
    private static final long[] AWAIT_TIMES = new long[]{20L, 50L, 100L, 100L, 200L};
    private final BatchTransformation<I, O> _transformation;
    private final BlockingQueue<BatchEntry<I, O>> _queue;
    private final AtomicInteger _batchNo;
    private final int _maxBatchSize;
    private final ScheduledExecutorService _threadPool;
    private final int _flushInterval;

    public BatchTransformationBuffer(BatchTransformation<I, O> transformation) {
        this(transformation, 20, 1000);
    }

    public BatchTransformationBuffer(BatchTransformation<I, O> transformation, int maxBatchSize, int flushIntervalMillis) {
        this._transformation = transformation;
        this._flushInterval = flushIntervalMillis;
        this._maxBatchSize = maxBatchSize;
        this._queue = new ArrayBlockingQueue<BatchEntry<I, O>>(maxBatchSize);
        this._batchNo = new AtomicInteger();
        this._threadPool = Executors.newScheduledThreadPool(1);
    }

    public void start() {
        logger.info("start()");
        this._threadPool.scheduleAtFixedRate(this.createFlushCommand(), this._flushInterval, this._flushInterval, TimeUnit.MILLISECONDS);
    }

    private Runnable createFlushCommand() {
        return new Runnable(){

            @Override
            public void run() {
                BatchTransformationBuffer.this.flushBuffer(true);
            }
        };
    }

    public int getBatchCount() {
        return this._batchNo.get();
    }

    public void flushBuffer() {
        this.flushBuffer(false);
    }

    private void flushBuffer(boolean scheduled) {
        if (this._queue.isEmpty()) {
            return;
        }
        if (!scheduled && this._queue.size() < this._maxBatchSize) {
            logger.debug("Batch ignored, flush operation not scheduled and queue is not full");
            return;
        }
        ArrayList entries = new ArrayList(this._maxBatchSize);
        int batchSize = this._queue.drainTo(entries);
        if (batchSize == 0) {
            logger.debug("Batch ignored, no elements left in queue");
            return;
        }
        int batchNumber = this._batchNo.incrementAndGet();
        logger.info("Batch #{} - Preparing {} entries, scheduled={}", new Object[]{batchNumber, batchSize, scheduled});
        Object[] input = new Object[batchSize];
        for (int i = 0; i < batchSize; ++i) {
            input[i] = ((BatchEntry)entries.get(i)).getInput();
        }
        ArrayBatchSource source = new ArrayBatchSource(input);
        BatchEntryBatchSink sink = new BatchEntryBatchSink(entries);
        this._transformation.map(source, sink);
        logger.info("Batch #{} - Finished", (Object)batchNumber, (Object)batchSize);
        if (scheduled && !this._queue.isEmpty()) {
            this.flushBuffer(true);
        }
    }

    public void shutdown() {
        logger.info("shutdown()");
        this._threadPool.shutdown();
    }

    public O transform(I input) {
        BatchEntry entry = new BatchEntry(input);
        while (!this._queue.offer(entry)) {
            this.flushBuffer();
        }
        int attemptIndex = 0;
        while (true) {
            long waitTime = attemptIndex < AWAIT_TIMES.length ? AWAIT_TIMES[attemptIndex] : AWAIT_TIMES[AWAIT_TIMES.length - 1];
            try {
                boolean finished = entry.await(waitTime);
                if (finished) {
                    return entry.getOuput();
                }
                this.flushBuffer();
                ++attemptIndex;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
    }
}

