/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.batch;

import org.datacleaner.api.Close;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.Transformer;
import org.datacleaner.util.batch.BatchTransformation;
import org.datacleaner.util.batch.BatchTransformationBuffer;

public abstract class BatchTransformer
implements Transformer,
BatchTransformation<InputRow, Object[]> {
    private final BatchTransformationBuffer<InputRow, Object[]> _batchTransformationBuffer = new BatchTransformationBuffer<InputRow, Object[]>(this, this.getMaxBatchSize(), this.getFlushIntervalMillis());

    protected int getFlushIntervalMillis() {
        return 1000;
    }

    protected int getMaxBatchSize() {
        return 20;
    }

    @Initialize
    public final void initialize() {
        this._batchTransformationBuffer.start();
    }

    @Close
    public final void close() {
        this._batchTransformationBuffer.shutdown();
    }

    public final Object[] transform(InputRow inputRow) {
        return this._batchTransformationBuffer.transform(inputRow);
    }
}

