/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datacleaner.api.Converter;
import org.datacleaner.util.CharIterator;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayConverter
implements Converter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ArrayConverter.class);
    private final Converter<Object> _parentConvert;

    public ArrayConverter(Converter<Object> parentConverter) {
        this._parentConvert = parentConverter;
    }

    public Object fromString(Class<?> type, String str) {
        boolean isList = ReflectionUtils.is(type, List.class);
        if (isList) {
            type = String[].class;
        }
        str = str.trim();
        List<String> result = this.fromStringInternal(type, str);
        if (isList) {
            String[] array = (String[])result;
            result = Arrays.asList(array);
        }
        return result;
    }

    public Object fromStringInternal(Class<?> type, String str) {
        assert (type.isArray());
        Class<?> componentType = type.getComponentType();
        if ("[]".equals(str)) {
            logger.debug("found [], returning empty array");
            return Array.newInstance(componentType, 0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("deserializeArray(\"{}\")", (Object)str);
            logger.debug("component type is: {}", componentType);
            int beginningBrackets = 0;
            int endingBrackets = 0;
            CharIterator it = new CharIterator(str);
            while (it.hasNext()) {
                it.next();
                if (it.is(Character.valueOf('['))) {
                    ++beginningBrackets;
                    continue;
                }
                if (!it.is(Character.valueOf(']'))) continue;
                ++endingBrackets;
            }
            it.reset();
            logger.debug("brackets statistics: beginning={}, ending={}", (Object)beginningBrackets, (Object)endingBrackets);
            if (beginningBrackets != endingBrackets) {
                logger.warn("Unbalanced beginning and ending brackets!");
            }
        }
        if (!str.startsWith("[") || !str.endsWith("]")) {
            if (str.indexOf(44) == -1) {
                Object result = Array.newInstance(componentType, 1);
                Object singleItem = this._parentConvert.fromString(componentType, str);
                Array.set(result, 0, singleItem);
                return result;
            }
            throw new IllegalArgumentException("Cannot parse string as array, bracket encapsulation and comma delimitors expected. Found: " + str);
        }
        String innerString = str.substring(1, str.length() - 1);
        logger.debug("innerString: {}", (Object)innerString);
        ArrayList<Object> objects = new ArrayList<Object>();
        int offset = 0;
        while (offset < innerString.length()) {
            String s;
            logger.debug("offset: {}", (Object)offset);
            int commaIndex = innerString.indexOf(44, offset);
            logger.debug("commaIndex: {}", (Object)commaIndex);
            int bracketBeginIndex = innerString.indexOf(91, offset);
            logger.debug("bracketBeginIndex: {}", (Object)bracketBeginIndex);
            if (commaIndex == -1) {
                logger.debug("no comma found");
                s = innerString.substring(offset);
                Object item = this._parentConvert.fromString(componentType, s);
                objects.add(item);
                offset = innerString.length();
                continue;
            }
            if (bracketBeginIndex == -1 || commaIndex < bracketBeginIndex) {
                s = innerString.substring(offset, commaIndex);
                if ("".equals(s)) {
                    ++offset;
                    continue;
                }
                logger.debug("no brackets in next element: \"{}\"", (Object)s);
                Object item = this._parentConvert.fromString(componentType, s);
                objects.add(item);
                offset = commaIndex + 1;
                continue;
            }
            s = innerString.substring(bracketBeginIndex);
            int nextBracket = 0;
            int depth = 1;
            logger.debug("substring with nested array: {}", (Object)s);
            while (depth > 0) {
                int searchOffset = nextBracket + 1;
                int nextEndBracket = s.indexOf(93, searchOffset);
                if (nextEndBracket == -1) {
                    throw new IllegalStateException("No ending bracket in array string: " + s.substring(searchOffset));
                }
                int nextBeginBracket = s.indexOf(91, searchOffset);
                if (nextBeginBracket == -1) {
                    nextBeginBracket = s.length();
                }
                nextBracket = Math.min(nextEndBracket, nextBeginBracket);
                char c = s.charAt(nextBracket);
                logger.debug("nextBracket: {} ({})", (Object)nextBracket, (Object)Character.valueOf(c));
                if (c == '[') {
                    ++depth;
                } else if (c == ']') {
                    --depth;
                } else {
                    throw new IllegalStateException("Unexpected char: " + c);
                }
                logger.debug("depth: {}", (Object)depth);
                if (depth != 0) continue;
                s = s.substring(0, nextBracket + 1);
                logger.debug("identified array: {}", (Object)s);
            }
            logger.debug("recursing to nested array: {}", (Object)s);
            logger.debug("inner array string: " + s);
            Object item = this._parentConvert.fromString(componentType, s);
            objects.add(item);
            offset = bracketBeginIndex + s.length();
        }
        Object result = Array.newInstance(componentType, objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            Array.set(result, i, objects.get(i));
        }
        return result;
    }

    public String toString(Object o) {
        assert (o != null);
        assert (o.getClass().isArray() || o instanceof List);
        if (o instanceof List) {
            o = ((List)o).toArray();
        }
        StringBuilder sb = new StringBuilder();
        int length = Array.getLength(o);
        sb.append('[');
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(o, i);
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this._parentConvert.toString(obj));
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean isConvertable(Class<?> type) {
        return type.isArray() || ReflectionUtils.is(type, List.class);
    }
}

