/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import java.io.File;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.convert.ResourceConverter;

public class FileResourceTypeHandler
implements ResourceConverter.ResourceTypeHandler<FileResource> {
    public static final String DEFAULT_SCHEME = "file";
    private final String _scheme;
    private final File _relativeParentDirectory;

    public FileResourceTypeHandler() {
        this(null);
    }

    public FileResourceTypeHandler(File relativeParentDirectory) {
        this(DEFAULT_SCHEME, relativeParentDirectory);
    }

    public FileResourceTypeHandler(String scheme, File relativeParentDirectory) {
        this._scheme = scheme;
        this._relativeParentDirectory = relativeParentDirectory;
    }

    @Override
    public boolean isParserFor(Class<? extends Resource> resourceType) {
        return ReflectionUtils.is(resourceType, FileResource.class);
    }

    @Override
    public String getScheme() {
        return this._scheme;
    }

    @Override
    public FileResource parsePath(String path) {
        File file = this._relativeParentDirectory != null && !this.isAbsolute(path) ? new File(this._relativeParentDirectory, path) : new File(path);
        return new FileResource(file);
    }

    private boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    @Override
    public String createPath(Resource resource) {
        String path = ((FileResource)resource).getFile().getPath();
        path = path.replaceAll("\\\\", "/");
        return path;
    }
}

