/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.convert;

import org.apache.commons.vfs2.FileObject;
import org.apache.metamodel.util.Resource;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.VFSUtils;
import org.datacleaner.util.VfsResource;
import org.datacleaner.util.convert.ResourceConverter;

public class VfsResourceTypeHandler
implements ResourceConverter.ResourceTypeHandler<VfsResource> {
    @Override
    public boolean isParserFor(Class<? extends Resource> resourceType) {
        return ReflectionUtils.is(resourceType, VfsResource.class);
    }

    @Override
    public String getScheme() {
        return "vfs";
    }

    @Override
    public VfsResource parsePath(String path) {
        try {
            FileObject fileObject = VFSUtils.getFileSystemManager().resolveFile(path);
            return new VfsResource(fileObject);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String createPath(Resource resource) {
        VfsResource vfsResource = (VfsResource)resource;
        return vfsResource.getFileObject().getName().getFriendlyURI();
    }
}

