/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.LazyRef;
import org.datacleaner.util.http.MonitorHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CASMonitorHttpClient
implements MonitorHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(CASMonitorHttpClient.class);
    private final Charset charset = Charset.forName("UTF-8");
    private final HttpClient _httpClient;
    private final String _casServerUrl;
    private final String _username;
    private final String _password;
    private final String _monitorBaseUrl;
    private final LazyRef<String> _ticketGrantingTicketRef;
    private String _requestedService;
    private String _casRestServiceUrl;

    public CASMonitorHttpClient(HttpClient client, String casServerUrl, String username, String password, String monitorBaseUrl) {
        this._httpClient = client;
        this._casServerUrl = casServerUrl;
        this._username = username;
        this._password = password;
        this._monitorBaseUrl = monitorBaseUrl;
        this._requestedService = this._monitorBaseUrl + "/j_spring_cas_security_check";
        this._casRestServiceUrl = this._casServerUrl + "/v1/tickets";
        this._ticketGrantingTicketRef = this.createTicketGrantingTicketRef();
        logger.debug("Requested service url: {}", (Object)this._requestedService);
        logger.debug("Using CAS service url: {}", (Object)this._casRestServiceUrl);
    }

    private LazyRef<String> createTicketGrantingTicketRef() {
        return new LazyRef<String>(){

            protected String fetch() {
                try {
                    String ticketGrantingTicket = CASMonitorHttpClient.this.getTicketGrantingTicket(CASMonitorHttpClient.this._casRestServiceUrl);
                    logger.debug("Got a ticket granting ticket: {}", (Object)ticketGrantingTicket);
                    return ticketGrantingTicket;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException("Failed to fetch ticket granting ticket from CAS", e);
                }
            }
        };
    }

    @Override
    public HttpResponse execute(HttpUriRequest request) throws Exception {
        String ticketGrantingTicket;
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-store", (Object)cookieStore);
        this._httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        try {
            ticketGrantingTicket = (String)this._ticketGrantingTicketRef.get();
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof SSLPeerUnverifiedException) {
                throw (SSLPeerUnverifiedException)e.getCause();
            }
            throw e;
        }
        String ticket = this.getTicket(this._requestedService, this._casRestServiceUrl, ticketGrantingTicket, (HttpContext)context);
        logger.debug("Got a service ticket: {}", (Object)ticketGrantingTicket);
        logger.debug("Cookies 2: {}", (Object)cookieStore.getCookies());
        HttpGet cookieRequest = new HttpGet(this._requestedService + "?ticket=" + ticket);
        HttpResponse cookieResponse = this.executeHttpRequest((HttpUriRequest)cookieRequest, (HttpContext)context);
        EntityUtils.consume((HttpEntity)cookieResponse.getEntity());
        cookieRequest.releaseConnection();
        logger.debug("Cookies 3: {}", (Object)cookieStore.getCookies());
        HttpResponse result = this.executeHttpRequest(request, (HttpContext)context);
        logger.debug("Cookies 4: {}", (Object)cookieStore.getCookies());
        return result;
    }

    public String getTicket(String requestedService, String casServiceUrl, String ticketGrantingTicket, HttpContext context) throws IOException, Exception {
        HttpPost post = new HttpPost(casServiceUrl + "/" + ticketGrantingTicket);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("service", requestedService));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, this.charset);
        post.setEntity((HttpEntity)entity);
        HttpResponse response = this.executeHttpRequest((HttpUriRequest)post, context);
        String ticket = this.readResponse(response.getEntity());
        post.releaseConnection();
        return ticket;
    }

    private HttpResponse executeHttpRequest(HttpUriRequest req, HttpContext context) throws IOException {
        logger.debug("Executing HTTP request: {}", (Object)req);
        return this._httpClient.execute(req, context);
    }

    public String getTicketGrantingTicket(String casServiceUrl) throws Exception {
        String ticketGrantingTicket;
        Header locationHeader;
        String reason;
        HttpPost ticketServiceRequest = new HttpPost(casServiceUrl);
        ticketServiceRequest.setEntity((HttpEntity)new StringEntity("username=" + this._username + "&password=" + this._password));
        HttpResponse casResponse = this.executeHttpRequest((HttpUriRequest)ticketServiceRequest, null);
        StatusLine statusLine = casResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode == 302) {
            reason = statusLine.getReasonPhrase();
            this.throwError("Unexpected HTTP status code from CAS service: 302. This indicates that the RESTful API for CAS is not installed. Reason: " + reason);
        }
        if (statusCode != 201) {
            reason = statusLine.getReasonPhrase();
            logger.error("Unexpected HTTP status code from CAS service request: {}. Reason: {}", (Object)statusCode, (Object)reason);
            this.throwError(statusCode + " - " + reason);
        }
        if ((locationHeader = casResponse.getFirstHeader("Location")) == null) {
            this.throwError("Header 'Location' is null");
        }
        ticketServiceRequest.releaseConnection();
        String locationResponse = locationHeader.getValue();
        int tgtIndex = locationResponse.indexOf("TGT");
        if (tgtIndex == -1) {
            this.throwError("No TGT element in 'Location' header: " + locationResponse);
        }
        if ((ticketGrantingTicket = locationResponse.substring(tgtIndex)) == null) {
            this.throwError("CAS ticket is null");
        }
        EntityUtils.consume((HttpEntity)casResponse.getEntity());
        return ticketGrantingTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(HttpEntity entity) throws Exception {
        String string;
        InputStream in = entity.getContent();
        if (in == null) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                if (sb.length() != 0) {
                    sb.append('\n');
                }
                sb.append(line);
                line = reader.readLine();
            }
            String result = sb.toString();
            logger.debug("Response: ", (Object)result);
            string = result;
        }
        catch (Throwable throwable) {
            FileHelper.safeClose((Object[])new Object[]{in});
            throw throwable;
        }
        FileHelper.safeClose((Object[])new Object[]{in});
        return string;
    }

    private void throwError(String message) throws Exception {
        throw new IllegalStateException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this._ticketGrantingTicketRef.isFetched()) {
            String ticketGrantingTicket = (String)this._ticketGrantingTicketRef.get();
            HttpDelete request = new HttpDelete(this._casRestServiceUrl + "/" + ticketGrantingTicket);
            try {
                HttpResponse response = this.executeHttpRequest((HttpUriRequest)request, null);
                if (logger.isDebugEnabled()) {
                    String responseStr = this.readResponse(response.getEntity());
                    logger.debug("Log out response: {}", (Object)responseStr);
                } else {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Exception e) {
                logger.warn("Failed to log out of CAS: " + e.getMessage(), (Throwable)e);
            }
            finally {
                request.releaseConnection();
            }
        }
    }
}

