/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.http;

import java.util.ArrayList;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.datacleaner.util.http.MonitorHttpClient;

public class HttpBasicMonitorHttpClient
implements MonitorHttpClient {
    private final DefaultHttpClient _httpClient;

    public HttpBasicMonitorHttpClient(HttpClient httpClient, String hostname, int port, String username, String password) {
        this._httpClient = (DefaultHttpClient)httpClient;
        CredentialsProvider credentialsProvider = this._httpClient.getCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        ArrayList<String> authpref = new ArrayList<String>();
        authpref.add("Basic");
        authpref.add("Digest");
        this._httpClient.getParams().setParameter("http.auth.proxy-scheme-pref", authpref);
        credentialsProvider.setCredentials(new AuthScope(hostname, port), (Credentials)credentials);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request) throws Exception {
        return this._httpClient.execute(request);
    }

    @Override
    public void close() {
    }
}

