/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.util.ws;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.ws.WebServiceException;
import org.datacleaner.util.ws.ServiceResult;
import org.datacleaner.util.ws.ServiceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServiceSession<R>
implements ServiceSession<R> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleServiceSession.class);
    private final AtomicInteger _requestCount = new AtomicInteger();
    private final AtomicInteger _activeRequestsCount = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResult<R> invokeService(Callable<R> callable) {
        this._requestCount.incrementAndGet();
        this._activeRequestsCount.incrementAndGet();
        try {
            R result = callable.call();
            ServiceResult<R> serviceResult = new ServiceResult<R>(result);
            return serviceResult;
        }
        catch (Throwable e) {
            if (e instanceof WebServiceException && e.getCause() != null) {
                logger.info("Exception thrown was a WebServiceException. Handling cause exception instead.", e);
                e = e.getCause();
            }
            ServiceResult serviceResult = new ServiceResult(e);
            return serviceResult;
        }
        finally {
            this._activeRequestsCount.decrementAndGet();
        }
    }

    public int getRequestCount() {
        return this._requestCount.get();
    }

    public int getActiveRequestsCount() {
        return this._activeRequestsCount.get();
    }

    @Override
    public <E> E invokeAdhocService(Callable<E> callable) throws RuntimeException, IllegalStateException {
        try {
            E result = callable.call();
            return result;
        }
        catch (Throwable e) {
            if (e instanceof WebServiceException && e.getCause() != null) {
                logger.info("Exception thrown was a WebServiceException. Throwing cause exception instead.", e);
                e = e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException("Failed to invoke adhoc service", e);
        }
    }
}

