/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.Properties;
import org.apache.metamodel.util.FileHelper;

public class Version {
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    private static final String VERSION = Version.determineVersion();
    private static final String DISTRIBUTION_VERSION;
    private static final String EDITION;
    public static final String EDITION_COMMUNITY = "Community edition";

    @Deprecated
    public static String get() {
        return Version.getVersion();
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getEdition() {
        return EDITION;
    }

    public static Integer getMajorVersion() {
        if (VERSION.equals(UNKNOWN_VERSION)) {
            return null;
        }
        String[] versionParts = VERSION.split("\\.");
        int majorVersion = Integer.parseInt(versionParts[0]);
        return majorVersion;
    }

    public static String getDistributionVersion() {
        return DISTRIBUTION_VERSION;
    }

    public static String getLicenseKey() {
        return System.getProperty("datacleaner.license.key");
    }

    private static String determineDistributionVersion() {
        String version = null;
        if (version == null) {
            version = Version.determineVersionFromMavenProperties("com.hi.datacleaner", "DataCleaner-enterprise-edition-core-components", null);
        }
        if (version == null) {
            version = Version.determineVersionFromMavenProperties("com.hi.datacleaner", "DataCleaner-desktop-app", null);
        }
        if (version == null) {
            version = Version.determineVersion();
        }
        return version;
    }

    private static String determineVersion() {
        return Version.determineVersionFromMavenProperties("org.eobjects.datacleaner", "DataCleaner-api", UNKNOWN_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String determineVersionFromMavenProperties(String groupId, String artifactId, String valueIfNull) {
        Properties properties = new Properties();
        String resourcePath = "/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        InputStream inputStream = Version.class.getResourceAsStream(resourcePath);
        try {
            properties.load(inputStream);
        }
        catch (Exception e) {
            String string;
            try {
                System.err.println("Failed to load DataCleaner version from manifest: " + e.getMessage());
                string = valueIfNull;
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            return string;
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        String version = properties.getProperty("version", valueIfNull);
        return version;
    }

    private static String determineEdition() {
        String systemProperty = System.getProperty("datacleaner.edition.name");
        if (!Strings.isNullOrEmpty((String)systemProperty)) {
            return systemProperty;
        }
        return EDITION_COMMUNITY;
    }

    public static boolean isCommunityEdition() {
        return Version.getEdition() == EDITION_COMMUNITY;
    }

    static {
        EDITION = Version.determineEdition();
        DISTRIBUTION_VERSION = Version.determineDistributionVersion();
    }
}

