/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Initialize;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.api.Validate;
import org.datacleaner.components.categories.ConversionCategory;
import org.datacleaner.util.convert.NowDate;
import org.datacleaner.util.convert.ShiftedToday;
import org.datacleaner.util.convert.TodayDate;
import org.datacleaner.util.convert.YesterdayDate;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Named(value="Convert to date")
@Description(value="Converts anything to a date (or null).")
@Categorized(value={ConversionCategory.class})
public class ConvertToDateTransformer
implements Transformer {
    private static final String[] prototypePatterns = new String[]{"yyyy-MM-dd", "dd-MM-yyyy", "MM-dd-yyyy"};
    private static ConvertToDateTransformer internalInstance;
    @Inject
    @Configured(order=1)
    InputColumn<?>[] input;
    @Inject
    @Configured(order=2)
    @Description(value="Default time zone to use if the date mask does not itself specify the time zone.")
    String timeZone = TimeZone.getDefault().getID();
    @Inject
    @Configured(required=false, order=3)
    @Description(value="What value to return when the string cannot be parsed using any of the date masks.")
    Date nullReplacement;
    @Inject
    @Configured(required=false, order=4)
    @Description(value="A sequence of date masks that will be tested from first to last until a match is found.")
    String[] dateMasks = this.getDefaultDateMasks();
    private DateTimeFormatter[] _dateTimeFormatters;
    private DateTimeFormatter _numberBasedDateTimeFormatterLong;
    private DateTimeFormatter _numberBasedDateTimeFormatterShort;

    public static ConvertToDateTransformer getInternalInstance() {
        if (internalInstance == null) {
            ConvertToDateTransformer newInst = new ConvertToDateTransformer();
            newInst.init();
            internalInstance = newInst;
        }
        return internalInstance;
    }

    @Validate
    public void validate() {
        try {
            TimeZone.getTimeZone(this.timeZone);
        }
        catch (Exception e) {
            throw new IllegalStateException("Time zone '" + this.timeZone + "' not recognized.");
        }
    }

    @Initialize
    public void init() {
        if (this.dateMasks == null) {
            this.dateMasks = this.getDefaultDateMasks();
        }
        DateTimeZone zone = DateTimeZone.forID((String)this.timeZone);
        this._numberBasedDateTimeFormatterLong = DateTimeFormat.forPattern((String)"yyyyMMdd").withZone(zone);
        this._numberBasedDateTimeFormatterShort = DateTimeFormat.forPattern((String)"yyMMdd").withZone(zone);
        this._dateTimeFormatters = new DateTimeFormatter[this.dateMasks.length];
        for (int i = 0; i < this.dateMasks.length; ++i) {
            String dateMask = this.dateMasks[i];
            this._dateTimeFormatters[i] = DateTimeFormat.forPattern((String)dateMask).withZone(zone);
        }
    }

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.input.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.input[i].getName() + " (as date)";
        }
        return new OutputColumns(Date.class, names);
    }

    public Date[] transform(InputRow inputRow) {
        Date[] result = new Date[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            Object value = inputRow.getValue(this.input[i]);
            Date d = this.transformValue(value);
            if (d == null) {
                d = this.nullReplacement;
            }
            result[i] = d;
        }
        return result;
    }

    public Date transformValue(Object value) {
        Date d = null;
        if (value != null) {
            if (value instanceof Date) {
                d = (Date)value;
            } else if (value instanceof Calendar) {
                d = ((Calendar)value).getTime();
            } else if (value instanceof String) {
                d = this.convertFromString((String)value);
            } else if (value instanceof Number) {
                d = this.convertFromNumber((Number)value, true);
            }
        }
        return d;
    }

    protected Date convertFromString(String value) {
        if (value == null) {
            return null;
        }
        if ("now()".equalsIgnoreCase(value)) {
            return new NowDate();
        }
        if ("today()".equalsIgnoreCase(value)) {
            return new TodayDate();
        }
        if ("yesterday()".equalsIgnoreCase(value)) {
            return new YesterdayDate();
        }
        if (value.matches("shifted_today(.+)")) {
            return new ShiftedToday(value);
        }
        for (DateTimeFormatter formatter : this._dateTimeFormatters) {
            try {
                return formatter.parseDateTime(value).toDate();
            }
            catch (Exception exception) {
            }
        }
        try {
            long longValue = Long.parseLong(value);
            return this.convertFromNumber(longValue, false);
        }
        catch (NumberFormatException longValue) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S");
            format.setTimeZone(TimeZone.getTimeZone(this.timeZone));
            try {
                return format.parse(value);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    protected Date convertFromNumber(Number value) {
        return this.convertFromNumber(value, true);
    }

    protected Date convertFromNumber(Number value, boolean tryDateTimeFormatters) {
        long longValue = value.longValue();
        String stringValue = Long.toString(longValue);
        if (tryDateTimeFormatters) {
            for (int i = 0; i < this._dateTimeFormatters.length; ++i) {
                boolean isPotentialNumberDateMask;
                String dateMask = this.dateMasks[i];
                boolean bl = isPotentialNumberDateMask = !dateMask.contains("-") && !dateMask.contains(".") && !dateMask.contains("/");
                if (!isPotentialNumberDateMask) continue;
                DateTimeFormatter formatter = this._dateTimeFormatters[i];
                try {
                    return formatter.parseDateTime(stringValue).toDate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (stringValue.length() == 8 && (stringValue.startsWith("1") || stringValue.startsWith("2"))) {
            try {
                return this._numberBasedDateTimeFormatterLong.parseDateTime(stringValue).toDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stringValue.length() == 6) {
            try {
                return this._numberBasedDateTimeFormatterShort.parseDateTime(stringValue).toDate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (longValue > 5000000L) {
            return new Date(longValue);
        }
        return new Date(longValue * 1000L * 60L * 60L * 24L);
    }

    private String[] getDefaultDateMasks() {
        ArrayList<String> defaultDateMasks = new ArrayList<String>();
        defaultDateMasks.add("yyyy-MM-dd HH:mm:ss.S");
        defaultDateMasks.add("yyyy-MM-dd HH:mm:ss");
        defaultDateMasks.add("yyyy-MM-dd HH:mm");
        defaultDateMasks.add("yyyyMMddHHmmssZ");
        defaultDateMasks.add("yyMMddHHmmssZ");
        for (String string : prototypePatterns) {
            defaultDateMasks.add(string);
            string = string.replaceAll("\\-", "\\.");
            defaultDateMasks.add(string);
            string = string.replaceAll("\\.", "\\/");
            defaultDateMasks.add(string);
        }
        return defaultDateMasks.toArray(new String[defaultDateMasks.size()]);
    }

    public String[] getDateMasks() {
        return this.dateMasks;
    }

    public Date getNullReplacement() {
        return this.nullReplacement;
    }

    public void setNullReplacement(Date nullReplacement) {
        this.nullReplacement = nullReplacement;
    }
}

