/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.convert;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.ConversionCategory;
import org.datacleaner.util.Percentage;
import org.datacleaner.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="Convert to number")
@Description(value="Converts anything to a number (or null if not possible).")
@Categorized(value={ConversionCategory.class})
public class ConvertToNumberTransformer
implements Transformer {
    private static final Logger logger = LoggerFactory.getLogger(ConvertToNumberTransformer.class);
    @Inject
    @Configured
    InputColumn<?>[] input;
    @Inject
    @Configured
    char decimalSeparator = DecimalFormatSymbols.getInstance().getDecimalSeparator();
    @Inject
    @Configured
    char thousandSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
    @Inject
    @Configured
    char minusSign = DecimalFormatSymbols.getInstance().getMinusSign();
    @Inject
    @Configured(required=false)
    Number nullReplacement;

    public ConvertToNumberTransformer() {
    }

    public ConvertToNumberTransformer(char decimalSeparator, char thousandSeparator, char minusSign) {
        this();
        this.decimalSeparator = decimalSeparator;
        this.thousandSeparator = thousandSeparator;
        this.minusSign = minusSign;
    }

    public DecimalFormat getDecimalFormat() {
        DecimalFormat format = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(this.decimalSeparator);
        symbols.setGroupingSeparator(this.thousandSeparator);
        symbols.setMinusSign(this.minusSign);
        format.setDecimalFormatSymbols(symbols);
        return format;
    }

    public OutputColumns getOutputColumns() {
        String[] names = new String[this.input.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.input[i].getName() + " (as number)";
        }
        return new OutputColumns(Number.class, names);
    }

    public Number[] transform(InputRow inputRow) {
        Number[] result = new Number[this.input.length];
        for (int i = 0; i < this.input.length; ++i) {
            Object value = inputRow.getValue(this.input[i]);
            Number n = this.transform(value);
            if (n == null) {
                n = this.nullReplacement;
            }
            result[i] = n;
        }
        return result;
    }

    protected Number transform(Object value) {
        return ConvertToNumberTransformer.transformValue(value, this.getDecimalFormat());
    }

    public static Number transformValue(Object value) {
        DecimalFormat format = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(',');
        symbols.setMinusSign('-');
        format.setDecimalFormatSymbols(symbols);
        return ConvertToNumberTransformer.transformValue(value, format);
    }

    public static Number transformValue(Object value, DecimalFormat decimalFormat) {
        Number n = null;
        if (value != null) {
            if (value instanceof Number) {
                n = (Number)value;
            } else if (value instanceof Boolean) {
                n = Boolean.TRUE.equals(value) ? Integer.valueOf(1) : Integer.valueOf(0);
            } else if (value instanceof Date) {
                Date d = (Date)value;
                n = d.getTime();
            } else if (value instanceof Character) {
                Character c = (Character)value;
                if (!Character.isDigit(c.charValue())) {
                    n = (int)c.charValue();
                }
            } else {
                String stringValue = value.toString();
                if ((stringValue = StringUtils.replaceWhitespaces(stringValue, "")).startsWith("+")) {
                    stringValue = stringValue.substring(1);
                }
                try {
                    n = stringValue.indexOf(37) != -1 ? Percentage.parsePercentage(stringValue) : decimalFormat.parse(stringValue);
                }
                catch (Exception e) {
                    logger.info("Error occured parsing string as number: {}", (Object)stringValue);
                }
            }
        }
        return n;
    }

    public void setInput(InputColumn<?> ... input) {
        this.input = input;
    }

    public void setNullReplacement(Number nullReplacement) {
        this.nullReplacement = nullReplacement;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public void setMinusSign(char minusSign) {
        this.minusSign = minusSign;
    }

    public void setThousandSeparator(char thousandSeparator) {
        this.thousandSeparator = thousandSeparator;
    }
}

