/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.maxrows;

import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Named;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Column;
import org.datacleaner.api.Categorized;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.Distributed;
import org.datacleaner.api.HasLabelAdvice;
import org.datacleaner.api.HiddenProperty;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.NumberProperty;
import org.datacleaner.api.QueryOptimizedFilter;
import org.datacleaner.api.Validate;
import org.datacleaner.components.categories.FilterCategory;

@Named(value="Max rows")
@Description(value="Sets a maximum number of rows to process.")
@Categorized(value={FilterCategory.class})
@Distributed(value=false)
public class MaxRowsFilter
implements QueryOptimizedFilter<Category>,
HasLabelAdvice {
    public static final String PROPERTY_APPLY_ORDERING = "Apply ordering";
    @Configured
    @NumberProperty(negative=false, zero=false)
    @Description(value="The maximum number of rows to process.")
    int maxRows = 1000;
    @Configured
    @NumberProperty(negative=false, zero=false)
    @Description(value="The first row (aka 'offset') to process.")
    int firstRow = 1;
    @Configured(value="Apply ordering", order=1000, required=false)
    @HiddenProperty
    boolean applyOrdering = true;
    @Configured(order=1001, required=false)
    @Description(value="Optional column to use for specifying dataset ordering. Use if consistent pagination is needed.")
    InputColumn<?> orderColumn;
    private final AtomicInteger counter = new AtomicInteger();

    public MaxRowsFilter() {
    }

    public MaxRowsFilter(int firstRow, int maxRows) {
        this();
        this.firstRow = firstRow;
        this.maxRows = maxRows;
    }

    public String getSuggestedLabel() {
        return "Max " + this.getMaxRows() + " rows";
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public InputColumn<?> getOrderColumn() {
        return this.orderColumn;
    }

    public void setOrderColumn(InputColumn<?> orderColumn) {
        this.orderColumn = orderColumn;
    }

    public void setApplyOrdering(boolean applyOrdering) {
        this.applyOrdering = applyOrdering;
    }

    public boolean isApplyOrdering() {
        return this.applyOrdering;
    }

    @Validate
    public void validate() {
        if (this.maxRows <= 0) {
            throw new IllegalStateException("Max rows value must be a positive integer");
        }
        if (this.firstRow <= 0) {
            throw new IllegalStateException("First row value must be a positive integer");
        }
    }

    public Category categorize(InputRow inputRow) {
        int count = this.counter.incrementAndGet();
        if (count < this.firstRow || count >= this.maxRows + this.firstRow) {
            return Category.INVALID;
        }
        return Category.VALID;
    }

    public boolean isOptimizable(Category category) {
        return category == Category.VALID;
    }

    public Query optimizeQuery(Query q, Category category) {
        if (category == Category.VALID) {
            Integer previousMaxRows = q.getMaxRows();
            Integer previousFirstRow = q.getFirstRow();
            if (this.firstRow > 1) {
                if (previousFirstRow == null) {
                    q.setFirstRow(Integer.valueOf(this.firstRow));
                } else {
                    int newFirstRow = previousFirstRow + this.firstRow;
                    q.setFirstRow(Integer.valueOf(newFirstRow));
                }
            }
            if (previousMaxRows == null) {
                q.setMaxRows(Integer.valueOf(this.maxRows));
            } else {
                int newMaxRows = Math.min(previousMaxRows, this.maxRows);
                if (previousFirstRow != null) {
                    Integer newFirstRow = q.getFirstRow();
                    int maxWindowSizeFrombefore = previousFirstRow + previousMaxRows - newFirstRow;
                    newMaxRows = Math.min(newMaxRows, maxWindowSizeFrombefore);
                }
                newMaxRows = Math.max(0, newMaxRows);
                q.setMaxRows(Integer.valueOf(newMaxRows));
            }
            if (this.applyOrdering && this.orderColumn != null) {
                Column physicalColumn = this.orderColumn.getPhysicalColumn();
                q.orderBy(physicalColumn);
            }
        } else {
            throw new IllegalStateException("Can only optimize the VALID max rows category");
        }
        return q;
    }

    public static enum Category {
        VALID,
        INVALID;

    }
}

