/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import java.util.Collection;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerEnvironment;
import org.datacleaner.configuration.DataCleanerEnvironmentImpl;
import org.datacleaner.configuration.DataCleanerHomeFolder;
import org.datacleaner.configuration.DataCleanerHomeFolderImpl;
import org.datacleaner.configuration.ServerInformation;
import org.datacleaner.configuration.ServerInformationCatalog;
import org.datacleaner.configuration.ServerInformationCatalogImpl;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreCatalog;
import org.datacleaner.connection.DatastoreCatalogImpl;
import org.datacleaner.reference.ReferenceDataCatalog;
import org.datacleaner.reference.ReferenceDataCatalogImpl;
import org.datacleaner.repository.file.FileRepository;

public class DataCleanerConfigurationImpl
implements DataCleanerConfiguration {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_FILENAME = "conf.xml";
    private final transient DataCleanerEnvironment _environment;
    private final transient DataCleanerHomeFolder _homeFolder;
    private final DatastoreCatalog _datastoreCatalog;
    private final ReferenceDataCatalog _referenceDataCatalog;
    private final ServerInformationCatalog _serverInformationCatalog;

    public DataCleanerConfigurationImpl() {
        this(DataCleanerConfigurationImpl.defaultEnvironment(), DataCleanerConfigurationImpl.defaultHomeFolder(), DataCleanerConfigurationImpl.defaultDatastoreCatalog(), DataCleanerConfigurationImpl.defaultReferenceDataCatalog(), DataCleanerConfigurationImpl.defaultServerInformationCatalog());
    }

    public DataCleanerConfigurationImpl(DataCleanerEnvironment environment, DataCleanerHomeFolder homeFolder) {
        this(environment, homeFolder, DataCleanerConfigurationImpl.defaultDatastoreCatalog(), DataCleanerConfigurationImpl.defaultReferenceDataCatalog(), DataCleanerConfigurationImpl.defaultServerInformationCatalog());
    }

    public DataCleanerConfigurationImpl(DataCleanerConfiguration c) {
        this(c.getEnvironment(), c.getHomeFolder(), c.getDatastoreCatalog(), c.getReferenceDataCatalog(), DataCleanerConfigurationImpl.defaultServerInformationCatalog());
    }

    public DataCleanerConfigurationImpl(DataCleanerEnvironment environment, DataCleanerHomeFolder homeFolder, DatastoreCatalog datastoreCatalog, ReferenceDataCatalog referenceDataCatalog) {
        this(environment, homeFolder, datastoreCatalog, referenceDataCatalog, DataCleanerConfigurationImpl.defaultServerInformationCatalog());
    }

    public DataCleanerConfigurationImpl(DataCleanerEnvironment environment, DataCleanerHomeFolder homeFolder, DatastoreCatalog datastoreCatalog, ReferenceDataCatalog referenceDataCatalog, ServerInformationCatalog serverInformationCatalog) {
        this._environment = environment == null ? DataCleanerConfigurationImpl.defaultEnvironment() : environment;
        this._homeFolder = homeFolder == null ? DataCleanerConfigurationImpl.defaultHomeFolder() : homeFolder;
        this._datastoreCatalog = datastoreCatalog == null ? DataCleanerConfigurationImpl.defaultDatastoreCatalog() : datastoreCatalog;
        this._referenceDataCatalog = referenceDataCatalog == null ? DataCleanerConfigurationImpl.defaultReferenceDataCatalog() : referenceDataCatalog;
        this._serverInformationCatalog = serverInformationCatalog == null ? DataCleanerConfigurationImpl.defaultServerInformationCatalog() : serverInformationCatalog;
    }

    public DataCleanerConfigurationImpl withDatastoreCatalog(DatastoreCatalog datastoreCatalog) {
        return new DataCleanerConfigurationImpl(this.getEnvironment(), this.getHomeFolder(), datastoreCatalog, this.getReferenceDataCatalog(), this.getServerInformationCatalog());
    }

    public DataCleanerConfigurationImpl withDatastores(Datastore ... datastores) {
        return this.withDatastoreCatalog(new DatastoreCatalogImpl(datastores));
    }

    public DataCleanerConfigurationImpl withDatastores(Collection<Datastore> datastores) {
        return this.withDatastoreCatalog(new DatastoreCatalogImpl(datastores));
    }

    public DataCleanerConfigurationImpl withReferenceDataCatalog(ReferenceDataCatalog referenceDataCatalog) {
        return new DataCleanerConfigurationImpl(this.getEnvironment(), this.getHomeFolder(), this.getDatastoreCatalog(), referenceDataCatalog, this.getServerInformationCatalog());
    }

    public DataCleanerConfigurationImpl withHomeFolder(DataCleanerHomeFolder homeFolder) {
        return new DataCleanerConfigurationImpl(this.getEnvironment(), homeFolder, this.getDatastoreCatalog(), this.getReferenceDataCatalog(), this.getServerInformationCatalog());
    }

    public DataCleanerConfigurationImpl withEnvironment(DataCleanerEnvironment environment) {
        return new DataCleanerConfigurationImpl(environment, this.getHomeFolder(), this.getDatastoreCatalog(), this.getReferenceDataCatalog(), this.getServerInformationCatalog());
    }

    public DataCleanerConfigurationImpl withServerInformationCatalog(ServerInformationCatalog serverInformationCatalog) {
        return new DataCleanerConfigurationImpl(this.getEnvironment(), this.getHomeFolder(), this.getDatastoreCatalog(), this.getReferenceDataCatalog(), serverInformationCatalog);
    }

    public DatastoreCatalog getDatastoreCatalog() {
        return this._datastoreCatalog;
    }

    public ReferenceDataCatalog getReferenceDataCatalog() {
        return this._referenceDataCatalog;
    }

    public ServerInformationCatalog getServerInformationCatalog() {
        return this._serverInformationCatalog;
    }

    public DataCleanerHomeFolder getHomeFolder() {
        return this._homeFolder;
    }

    public DataCleanerEnvironment getEnvironment() {
        return this._environment;
    }

    public static ReferenceDataCatalog defaultReferenceDataCatalog() {
        return new ReferenceDataCatalogImpl();
    }

    public static DatastoreCatalog defaultDatastoreCatalog() {
        return new DatastoreCatalogImpl(new Datastore[0]);
    }

    public static ServerInformationCatalog defaultServerInformationCatalog() {
        return new ServerInformationCatalogImpl(new ServerInformation[0]);
    }

    public static DataCleanerHomeFolder defaultHomeFolder() {
        return new DataCleanerHomeFolderImpl(new FileRepository("."));
    }

    public static DataCleanerEnvironment defaultEnvironment() {
        return new DataCleanerEnvironmentImpl();
    }
}

