/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import org.datacleaner.configuration.DataCleanerEnvironment;
import org.datacleaner.configuration.EmptyRemoteServerConfigurationImpl;
import org.datacleaner.configuration.InjectionManagerFactory;
import org.datacleaner.configuration.InjectionManagerFactoryImpl;
import org.datacleaner.configuration.RemoteServerConfiguration;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.SimpleDescriptorProvider;
import org.datacleaner.job.concurrent.SingleThreadedTaskRunner;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.storage.InMemoryStorageProvider;
import org.datacleaner.storage.StorageProvider;

public class DataCleanerEnvironmentImpl
implements DataCleanerEnvironment {
    private final TaskRunner _taskRunner;
    private final DescriptorProvider _descriptorProvider;
    private final StorageProvider _storageProvider;
    private final InjectionManagerFactory _injectionManagerFactory;
    private final RemoteServerConfiguration _remoteServerConfiguration;

    public DataCleanerEnvironmentImpl(TaskRunner taskRunner, DescriptorProvider descriptorProvider, StorageProvider storageProvider, InjectionManagerFactory injectionManagerFactory) {
        this(taskRunner, descriptorProvider, storageProvider, injectionManagerFactory, null);
    }

    public DataCleanerEnvironmentImpl(TaskRunner taskRunner, DescriptorProvider descriptorProvider, StorageProvider storageProvider, InjectionManagerFactory injectionManagerFactory, RemoteServerConfiguration remoteServerConfiguration) {
        this._taskRunner = taskRunner == null ? DataCleanerEnvironmentImpl.defaultTaskRunner() : taskRunner;
        this._descriptorProvider = descriptorProvider == null ? DataCleanerEnvironmentImpl.defaultDescriptorProvider() : descriptorProvider;
        this._storageProvider = storageProvider == null ? DataCleanerEnvironmentImpl.defaultStorageProvider() : storageProvider;
        this._injectionManagerFactory = injectionManagerFactory == null ? DataCleanerEnvironmentImpl.defaultInjectionManagerFactory() : injectionManagerFactory;
        this._remoteServerConfiguration = remoteServerConfiguration == null ? DataCleanerEnvironmentImpl.defaultRemoteServerConfiguration() : remoteServerConfiguration;
    }

    public DataCleanerEnvironmentImpl() {
        this(DataCleanerEnvironmentImpl.defaultTaskRunner(), DataCleanerEnvironmentImpl.defaultDescriptorProvider(), DataCleanerEnvironmentImpl.defaultStorageProvider(), DataCleanerEnvironmentImpl.defaultInjectionManagerFactory(), DataCleanerEnvironmentImpl.defaultRemoteServerConfiguration());
    }

    public DataCleanerEnvironmentImpl(DataCleanerEnvironment e) {
        this(e.getTaskRunner(), e.getDescriptorProvider(), e.getStorageProvider(), e.getInjectionManagerFactory(), e.getRemoteServerConfiguration());
    }

    public DataCleanerEnvironmentImpl withTaskRunner(TaskRunner taskRunner) {
        return new DataCleanerEnvironmentImpl(taskRunner, this.getDescriptorProvider(), this.getStorageProvider(), this.getInjectionManagerFactory(), this.getRemoteServerConfiguration());
    }

    public DataCleanerEnvironmentImpl withDescriptorProvider(DescriptorProvider descriptorProvider) {
        return new DataCleanerEnvironmentImpl(this.getTaskRunner(), descriptorProvider, this.getStorageProvider(), this.getInjectionManagerFactory(), this.getRemoteServerConfiguration());
    }

    public DataCleanerEnvironmentImpl withStorageProvider(StorageProvider storageProvider) {
        return new DataCleanerEnvironmentImpl(this.getTaskRunner(), this.getDescriptorProvider(), storageProvider, this.getInjectionManagerFactory(), this.getRemoteServerConfiguration());
    }

    public DataCleanerEnvironmentImpl withInjectionManagerFactory(InjectionManagerFactory injectionManagerFactory) {
        return new DataCleanerEnvironmentImpl(this.getTaskRunner(), this.getDescriptorProvider(), this.getStorageProvider(), injectionManagerFactory, this.getRemoteServerConfiguration());
    }

    public RemoteServerConfiguration getRemoteServerConfiguration() {
        return this._remoteServerConfiguration;
    }

    public TaskRunner getTaskRunner() {
        return this._taskRunner;
    }

    public DescriptorProvider getDescriptorProvider() {
        return this._descriptorProvider;
    }

    public StorageProvider getStorageProvider() {
        return this._storageProvider;
    }

    public InjectionManagerFactory getInjectionManagerFactory() {
        return this._injectionManagerFactory;
    }

    public static InjectionManagerFactory defaultInjectionManagerFactory() {
        return new InjectionManagerFactoryImpl();
    }

    public static StorageProvider defaultStorageProvider() {
        return new InMemoryStorageProvider();
    }

    public static DescriptorProvider defaultDescriptorProvider() {
        return new SimpleDescriptorProvider();
    }

    public static TaskRunner defaultTaskRunner() {
        return new SingleThreadedTaskRunner();
    }

    public static RemoteServerConfiguration defaultRemoteServerConfiguration() {
        return new EmptyRemoteServerConfigurationImpl();
    }
}

