/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import java.io.File;
import org.datacleaner.configuration.DataCleanerHomeFolder;
import org.datacleaner.repository.RepositoryFolder;
import org.datacleaner.repository.file.FileRepositoryFolder;
import org.datacleaner.util.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCleanerHomeFolderImpl
implements DataCleanerHomeFolder {
    private static final Logger logger = LoggerFactory.getLogger(DataCleanerHomeFolder.class);
    private final RepositoryFolder _repositoryFolder;
    private final File _file;

    public DataCleanerHomeFolderImpl(RepositoryFolder repositoryFolder) {
        if (repositoryFolder == null) {
            throw new IllegalArgumentException("RepositoryFolder cannot be null");
        }
        this._repositoryFolder = repositoryFolder;
        if (repositoryFolder instanceof FileRepositoryFolder) {
            this._file = ((FileRepositoryFolder)repositoryFolder).getFile();
            logger.debug("RepositoryFolder is file-based, using file representation: {}", (Object)this._file);
        } else {
            this._file = new File(SystemProperties.getString("user.home", ".") + "/.datacleaner");
            this._file.mkdirs();
            logger.warn("RepositoryFolder is NOT file-based, using file representation: {}", (Object)this._file);
        }
    }

    public File toFile() {
        return this._file;
    }

    public RepositoryFolder toRepositoryFolder() {
        return this._repositoryFolder;
    }

    public String toString() {
        return this._repositoryFolder.toString();
    }
}

