/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.datacleaner.configuration.ConfigurationReaderInterceptor;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.configuration.DataCleanerEnvironment;
import org.datacleaner.configuration.DataCleanerEnvironmentImpl;
import org.datacleaner.configuration.DataCleanerHomeFolder;
import org.datacleaner.util.FileResolver;
import org.datacleaner.util.InputStreamToPropertiesMapFunc;
import org.datacleaner.util.convert.ResourceConverter;

public class DefaultConfigurationReaderInterceptor
implements ConfigurationReaderInterceptor {
    private final Map<String, String> _propertyOverrides;
    private final DataCleanerEnvironment _baseEnvironment;

    public DefaultConfigurationReaderInterceptor() {
        this((Resource)null);
    }

    public DefaultConfigurationReaderInterceptor(DataCleanerEnvironment baseEnvironment) {
        this((Resource)null, baseEnvironment);
    }

    public DefaultConfigurationReaderInterceptor(Map<String, String> propertyOverrides) {
        this(propertyOverrides, (DataCleanerEnvironment)new DataCleanerEnvironmentImpl());
    }

    public DefaultConfigurationReaderInterceptor(Map<String, String> propertyOverrides, DataCleanerEnvironment baseEnvironment) {
        this._propertyOverrides = propertyOverrides == null ? Collections.emptyMap() : propertyOverrides;
        this._baseEnvironment = baseEnvironment;
    }

    public DefaultConfigurationReaderInterceptor(Resource propertiesResource) {
        this(propertiesResource, (DataCleanerEnvironment)new DataCleanerEnvironmentImpl());
    }

    public DefaultConfigurationReaderInterceptor(Resource propertiesResource, DataCleanerEnvironment baseEnvironment) {
        this._propertyOverrides = propertiesResource == null || !propertiesResource.isExists() ? Collections.emptyMap() : (Map)propertiesResource.read((Func)new InputStreamToPropertiesMapFunc());
        this._baseEnvironment = baseEnvironment;
    }

    @Override
    public final String createFilename(String filename) {
        if (filename == null) {
            return null;
        }
        FileResolver resolver = this.createFileResolver();
        File file = resolver.toFile(filename);
        return resolver.toPath(file);
    }

    protected FileResolver createFileResolver() {
        return new FileResolver(this.getHomeFolder());
    }

    @Override
    public Resource createResource(String resourceUrl, DataCleanerConfiguration temporaryConfiguration) {
        ResourceConverter converter = new ResourceConverter(temporaryConfiguration, ResourceConverter.getConfiguredDefaultScheme()).withExtraHandlers(this.getExtraResourceTypeHandlers());
        Resource resource = converter.fromString(Resource.class, resourceUrl);
        return resource;
    }

    protected List<ResourceConverter.ResourceTypeHandler<?>> getExtraResourceTypeHandlers() {
        return new ArrayList();
    }

    protected File getRelativeParentDirectory() {
        return this.getHomeFolder().toFile();
    }

    @Override
    public String getTemporaryStorageDirectory() {
        return FileHelper.getTempDir().getAbsolutePath();
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    @Override
    public String getPropertyOverride(String variablePath) {
        String result = this._propertyOverrides.get(variablePath);
        if (result == null) {
            result = System.getProperty(variablePath);
        }
        return result;
    }

    @Override
    public DataCleanerHomeFolder getHomeFolder() {
        return DataCleanerConfigurationImpl.defaultHomeFolder();
    }

    @Override
    public DataCleanerEnvironment createBaseEnvironment() {
        return this._baseEnvironment;
    }
}

