/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.util.LazyRef;
import org.apache.metamodel.util.Ref;
import org.datacleaner.api.ComponentContext;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.api.Provided;
import org.datacleaner.configuration.AnalyzerBeansConfiguration;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.DataCleanerConfigurationImpl;
import org.datacleaner.configuration.DataCleanerEnvironment;
import org.datacleaner.configuration.DataCleanerHomeFolder;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.configuration.InjectionPoint;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreCatalog;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.SchemaNavigator;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.concurrent.ThreadLocalOutputRowCollector;
import org.datacleaner.job.runner.ComponentContextImpl;
import org.datacleaner.reference.ReferenceDataCatalog;
import org.datacleaner.result.renderer.RendererFactory;
import org.datacleaner.storage.CollectionFactory;
import org.datacleaner.storage.CollectionFactoryImpl;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;
import org.datacleaner.storage.RowAnnotationHandler;
import org.datacleaner.storage.RowAnnotationSampleContainer;
import org.datacleaner.util.convert.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionManagerImpl
implements InjectionManager {
    private static final Logger logger = LoggerFactory.getLogger(InjectionManagerImpl.class);
    private final DataCleanerConfiguration _configuration;
    private final AnalysisJob _job;
    private final Ref<RowAnnotationFactory> _rowAnntationFactoryRef;

    public InjectionManagerImpl(DataCleanerConfiguration configuration, AnalysisJob job) {
        this._configuration = configuration;
        this._job = job;
        this._rowAnntationFactoryRef = this.createRowAnnotationFactoryRef();
    }

    public InjectionManagerImpl(DataCleanerConfiguration configuration) {
        this(configuration, null);
    }

    private Ref<RowAnnotationFactory> createRowAnnotationFactoryRef() {
        return new LazyRef<RowAnnotationFactory>(){

            protected RowAnnotationFactory fetch() {
                logger.info("Creating RowAnnotationFactory for job: {}", (Object)InjectionManagerImpl.this._job);
                RowAnnotationFactory rowAnnotationFactory = InjectionManagerImpl.this._configuration.getEnvironment().getStorageProvider().createRowAnnotationFactory();
                if (rowAnnotationFactory == null) {
                    throw new IllegalStateException("Storage provider returned null RowAnnotationFactory!");
                }
                return rowAnnotationFactory;
            }
        };
    }

    public final <E> E getInstance(InjectionPoint<E> injectionPoint) {
        Object instance = this.getInstanceInternal(injectionPoint);
        if (instance == null) {
            logger.debug("Could not handle injection for injection point: {}", injectionPoint);
        }
        return (E)instance;
    }

    private DataCleanerConfiguration getConfiguration() {
        if (this._configuration == null) {
            return new DataCleanerConfigurationImpl();
        }
        return this._configuration;
    }

    protected Object getInstanceInternal(InjectionPoint<?> injectionPoint) {
        Class baseType = injectionPoint.getBaseType();
        if (baseType == ReferenceDataCatalog.class) {
            return this.getConfiguration().getReferenceDataCatalog();
        }
        if (baseType == OutputRowCollector.class) {
            return new ThreadLocalOutputRowCollector();
        }
        if (baseType == DatastoreCatalog.class) {
            return this.getConfiguration().getDatastoreCatalog();
        }
        if (baseType == CollectionFactory.class) {
            return new CollectionFactoryImpl(this.getConfiguration().getEnvironment().getStorageProvider());
        }
        if (baseType == RendererFactory.class) {
            return new RendererFactory(this.getConfiguration());
        }
        if (baseType == RowAnnotationFactory.class || baseType == RowAnnotationSampleContainer.class || baseType == RowAnnotationHandler.class) {
            return this._rowAnntationFactoryRef.get();
        }
        if (baseType == RowAnnotation.class) {
            return ((RowAnnotationFactory)this._rowAnntationFactoryRef.get()).createAnnotation();
        }
        if (baseType == AnalyzerBeansConfiguration.class) {
            if (this.getConfiguration() instanceof AnalyzerBeansConfiguration) {
                return this.getConfiguration();
            }
            return null;
        }
        if (baseType == DataCleanerConfiguration.class) {
            return this.getConfiguration();
        }
        if (baseType == DataCleanerEnvironment.class) {
            return this.getConfiguration().getEnvironment();
        }
        if (baseType == DataCleanerHomeFolder.class) {
            return this.getConfiguration().getHomeFolder();
        }
        if (baseType == TaskRunner.class) {
            return this.getConfiguration().getEnvironment().getTaskRunner();
        }
        if (baseType == AnalysisJob.class) {
            return this._job;
        }
        if (baseType == StringConverter.class) {
            if (this.getConfiguration() == null) {
                return new StringConverter(this);
            }
            return new StringConverter(this.getConfiguration(), this._job);
        }
        if (baseType == ComponentContext.class) {
            ComponentContextImpl componentContext = new ComponentContextImpl(this._job);
            return componentContext;
        }
        if (baseType == Datastore.class && this._job != null) {
            return this._job.getDatastore();
        }
        if (baseType == DatastoreConnection.class && this._job != null) {
            throw new UnsupportedOperationException("DatastoreConnections cannot be injected as of AnalyzerBeans 0.16. Inject a Datastore and manage a connection instead.");
        }
        if (baseType == DataContext.class && this._job != null) {
            throw new UnsupportedOperationException("DataContext cannot be injected as of AnalyzerBeans 0.16. Inject a Datastore and manage a connection instead.");
        }
        if (baseType == SchemaNavigator.class && this._job != null) {
            throw new UnsupportedOperationException("SchemaNavigator cannot be injected as of AnalyzerBeans 0.16. Inject a Datastore and manage a connection instead.");
        }
        if (injectionPoint.getAnnotation(Provided.class) != null && injectionPoint.isGenericType()) {
            Class clazz1 = injectionPoint.getGenericTypeArgument(0);
            if (baseType == List.class) {
                List list = this.getConfiguration().getEnvironment().getStorageProvider().createList(clazz1);
                return list;
            }
            if (baseType == Set.class) {
                Set set = this.getConfiguration().getEnvironment().getStorageProvider().createSet(clazz1);
                return set;
            }
            if (baseType == Map.class) {
                Class clazz2 = injectionPoint.getGenericTypeArgument(1);
                Map map = this.getConfiguration().getEnvironment().getStorageProvider().createMap(clazz1, clazz2);
                return map;
            }
        }
        return null;
    }
}

