/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.HasNameMapper;
import org.datacleaner.configuration.ServerInformation;
import org.datacleaner.configuration.ServerInformationCatalog;
import org.datacleaner.server.EnvironmentBasedHadoopClusterInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInformationCatalogImpl
implements ServerInformationCatalog {
    private static final Logger logger = LoggerFactory.getLogger(ServerInformationCatalogImpl.class);
    private static final long serialVersionUID = 1L;
    private final Collection<ServerInformation> _servers;

    public ServerInformationCatalogImpl(Collection<ServerInformation> servers) {
        if (servers == null) {
            throw new IllegalArgumentException("servers cannot be null");
        }
        this._servers = servers;
    }

    public ServerInformationCatalogImpl(ServerInformation ... servers) {
        ArrayList<ServerInformation> serversList = new ArrayList<ServerInformation>();
        Collections.addAll(serversList, servers);
        this._servers = serversList;
        try {
            EnvironmentBasedHadoopClusterInformation environmentBasedHadoopClusterInformation;
            if (!this.containsServer("org.datacleaner.hadoop.environment") && (environmentBasedHadoopClusterInformation = new EnvironmentBasedHadoopClusterInformation("org.datacleaner.hadoop.environment", null)).getDirectories().length > 0) {
                serversList.add(0, environmentBasedHadoopClusterInformation);
            }
        }
        catch (IllegalStateException e) {
            logger.info("No Hadoop environment variables, skipping default server");
        }
    }

    public String[] getServerNames() {
        List names = CollectionUtils.map(this._servers, (Func)new HasNameMapper());
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public ServerInformation getServer(String name) {
        if (name != null) {
            for (ServerInformation ds : this._servers) {
                if (!name.equals(ds.getName())) continue;
                return ds;
            }
        }
        return null;
    }
}

