/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.configuration;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.metamodel.schema.Column;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.SchemaNavigator;
import org.datacleaner.job.AnalysisJobMetadata;

public final class SourceColumnMapping {
    private final Map<String, Column> _map = new TreeMap<String, Column>();
    private Datastore _datastore;

    public SourceColumnMapping(AnalysisJobMetadata metadata) {
        this(metadata.getSourceColumnPaths());
    }

    public SourceColumnMapping(String ... originalColumnPaths) {
        for (String path : originalColumnPaths) {
            this._map.put(path, null);
        }
    }

    public SourceColumnMapping(List<String> sourceColumnPaths) {
        this(sourceColumnPaths.toArray(new String[sourceColumnPaths.size()]));
    }

    public void setDatastore(Datastore datastore) {
        this._datastore = datastore;
    }

    public Datastore getDatastore() {
        return this._datastore;
    }

    public void autoMap(Datastore datastore) {
        this.setDatastore(datastore);
        try (DatastoreConnection con = datastore.openConnection();){
            SchemaNavigator schemaNavigator = con.getSchemaNavigator();
            for (Map.Entry<String, Column> entry : this._map.entrySet()) {
                if (entry.getValue() != null) continue;
                String path = entry.getKey();
                Column column = schemaNavigator.convertToColumn(path);
                entry.setValue(column);
            }
        }
    }

    public boolean isSatisfied() {
        if (this._datastore == null) {
            return false;
        }
        for (Map.Entry<String, Column> entry : this._map.entrySet()) {
            if (entry.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public Column getColumn(String path) {
        return this._map.get(path);
    }

    public void setColumn(String path, Column column) {
        this._map.put(path, column);
    }

    public Set<String> getPaths() {
        return this._map.keySet();
    }

    public Set<String> getUnmappedPaths() {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<String, Column> entry : this._map.entrySet()) {
            if (entry.getValue() != null) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public String toString() {
        return "SourceColumnMapping[datastore=" + this._datastore + ",map=" + this._map + "]";
    }
}

