/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.DataContextFactory;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.DatastoreConnectionImpl;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.util.ReadObjectBuilder;

public final class CompositeDatastore
extends UsageAwareDatastore<DataContext> {
    private static final long serialVersionUID = 1L;
    private final List<? extends Datastore> _datastores;

    public CompositeDatastore(String name, List<? extends Datastore> datastores) {
        super(name);
        this._datastores = datastores;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, CompositeDatastore.class).readObject(stream);
    }

    public List<? extends Datastore> getDatastores() {
        return this._datastores;
    }

    @Override
    protected UsageAwareDatastoreConnection<DataContext> createDatastoreConnection() {
        ArrayList<DataContext> dataContexts = new ArrayList<DataContext>(this._datastores.size());
        ArrayList<DatastoreConnection> closeables = new ArrayList<DatastoreConnection>(this._datastores.size());
        for (Datastore datastore : this._datastores) {
            DatastoreConnection con = datastore.openConnection();
            DataContext dc = con.getDataContext();
            closeables.add(con);
            dataContexts.add(dc);
        }
        AutoCloseable[] closeablesArray = closeables.toArray(new Closeable[closeables.size()]);
        return new DatastoreConnectionImpl<DataContext>(DataContextFactory.createCompositeDataContext(dataContexts), this, closeablesArray);
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        boolean queryOptimizationPreferred = true;
        boolean naturalRecordOrderConsistent = true;
        for (Datastore datastore : this._datastores) {
            PerformanceCharacteristics performanceCharacteristics = datastore.getPerformanceCharacteristics();
            queryOptimizationPreferred = queryOptimizationPreferred && performanceCharacteristics.isQueryOptimizationPreferred();
            naturalRecordOrderConsistent = naturalRecordOrderConsistent && performanceCharacteristics.isNaturalRecordOrderConsistent();
        }
        return new PerformanceCharacteristicsImpl(queryOptimizationPreferred, naturalRecordOrderConsistent);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._datastores);
    }
}

