/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.schema.naming.CustomColumnNamingStrategy;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SerializableRef;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.FileDatastore;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.ResourceDatastore;
import org.datacleaner.connection.UpdateableDatastore;
import org.datacleaner.connection.UpdateableDatastoreConnection;
import org.datacleaner.connection.UpdateableDatastoreConnectionImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.util.ReadObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvDatastore
extends UsageAwareDatastore<UpdateableDataContext>
implements FileDatastore,
ResourceDatastore,
UpdateableDatastore {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CsvDatastore.class);
    public static final char NOT_A_CHAR = '\uffff';
    public static final char DEFAULT_QUOTE_CHAR = '\uffff';
    public static final char DEFAULT_SEPARATOR_CHAR = ',';
    private final SerializableRef<Resource> _resourceRef;
    private final String _filename;
    private final Character _quoteChar;
    private final Character _separatorChar;
    private final Character _escapeChar;
    private final String _encoding;
    private final boolean _failOnInconsistencies;
    private final boolean _multilineValues;
    private final int _headerLineNumber;
    private final List<String> _customColumnNames;

    public CsvDatastore(String name, Resource resource) {
        this(name, resource, resource.getName(), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf('\\'), "UTF-8", true, 1);
    }

    public CsvDatastore(String name, String filename) {
        this(name, filename, Character.valueOf('\"'), Character.valueOf(','), "UTF-8");
    }

    public CsvDatastore(String name, String filename, Character quoteChar, Character separatorChar, String encoding) {
        this(name, filename, quoteChar, separatorChar, encoding, true);
    }

    public CsvDatastore(String name, String filename, Character quoteChar, Character separatorChar, String encoding, boolean failOnInconsistencies) {
        this(name, filename, quoteChar, separatorChar, encoding, failOnInconsistencies, 1);
    }

    public CsvDatastore(String name, String filename, Character quoteChar, Character separatorChar, String encoding, boolean failOnInconsistencies, int headerLineNumber) {
        this(name, null, filename, quoteChar, separatorChar, Character.valueOf('\\'), encoding, failOnInconsistencies, headerLineNumber);
    }

    public CsvDatastore(String name, Resource resource, CsvConfiguration c) {
        this(name, resource, resource.getName(), Character.valueOf(c.getQuoteChar()), Character.valueOf(c.getSeparatorChar()), Character.valueOf(c.getEscapeChar()), c.getEncoding(), c.isFailOnInconsistentRowLength(), c.isMultilineValues(), c.getColumnNameLineNumber());
    }

    public CsvDatastore(String name, Resource resource, String filename, Character quoteChar, Character separatorChar, Character escapeChar, String encoding, boolean failOnInconsistencies, int headerLineNumber) {
        this(name, resource, filename, quoteChar, separatorChar, escapeChar, encoding, failOnInconsistencies, true, headerLineNumber);
    }

    public CsvDatastore(String name, Resource resource, String filename, Character quoteChar, Character separatorChar, Character escapeChar, String encoding, boolean failOnInconsistencies, boolean multilineValues, int headerLineNumber) {
        this(name, resource, filename, quoteChar, separatorChar, escapeChar, encoding, failOnInconsistencies, multilineValues, headerLineNumber, null);
    }

    public CsvDatastore(String name, Resource resource, String filename, Character quoteChar, Character separatorChar, Character escapeChar, String encoding, boolean failOnInconsistencies, boolean multilineValues, int headerLineNumber, List<String> customColumnNames) {
        super(name);
        this._filename = filename;
        if (resource == null) {
            resource = new FileResource(filename);
        }
        this._resourceRef = new SerializableRef((Object)resource);
        this._quoteChar = quoteChar;
        this._separatorChar = separatorChar;
        this._escapeChar = escapeChar;
        this._encoding = encoding;
        this._failOnInconsistencies = failOnInconsistencies;
        this._multilineValues = multilineValues;
        if (headerLineNumber < 0) {
            headerLineNumber = 0;
        }
        this._headerLineNumber = headerLineNumber;
        this._customColumnNames = customColumnNames;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, CsvDatastore.class).readObject(stream);
    }

    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    public Character getQuoteChar() {
        return this._quoteChar;
    }

    public Character getEscapeChar() {
        return this._escapeChar;
    }

    public Character getSeparatorChar() {
        return this._separatorChar;
    }

    @Override
    public Resource getResource() {
        if (this._resourceRef == null) {
            return null;
        }
        return (Resource)this._resourceRef.get();
    }

    public List<String> getCustomColumnNames() {
        return this._customColumnNames;
    }

    @Override
    protected UsageAwareDatastoreConnection<UpdateableDataContext> createDatastoreConnection() {
        CsvDataContext dataContext;
        Resource resource = this.getResource();
        if (resource == null) {
            logger.warn("Resource was not available, a local file reference will be created with path: {}", (Object)this._filename);
            dataContext = new CsvDataContext(new File(this._filename), this.getCsvConfiguration());
        } else {
            dataContext = new CsvDataContext(resource, this.getCsvConfiguration());
        }
        return new UpdateableDatastoreConnectionImpl<CsvDataContext>(dataContext, this, new AutoCloseable[0]);
    }

    public CsvConfiguration getCsvConfiguration() {
        String encoding;
        char separatorChar = this._separatorChar == null ? (char)',' : (char)this._separatorChar.charValue();
        char quoteChar = this._quoteChar == null ? (char)'\uffff' : (char)this._quoteChar.charValue();
        char escapeChar = this._escapeChar == null ? (char)'\\' : (char)this._escapeChar.charValue();
        String string = encoding = this._encoding == null ? "UTF-8" : this._encoding;
        if (this._customColumnNames == null || this._customColumnNames.size() == 0) {
            return new CsvConfiguration(this._headerLineNumber, encoding, separatorChar, quoteChar, escapeChar, this._failOnInconsistencies, this._multilineValues);
        }
        return new CsvConfiguration(this._headerLineNumber, (ColumnNamingStrategy)new CustomColumnNamingStrategy(this._customColumnNames), encoding, separatorChar, quoteChar, escapeChar, this._failOnInconsistencies, this._multilineValues);
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(false, true);
    }

    public boolean isFailOnInconsistencies() {
        return this._failOnInconsistencies;
    }

    public boolean isMultilineValues() {
        return this._multilineValues;
    }

    public int getHeaderLineNumber() {
        return this._headerLineNumber;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
        identifiers.add(this._encoding);
        identifiers.add(this._quoteChar);
        identifiers.add(this._escapeChar);
        identifiers.add(this._separatorChar);
        identifiers.add(this._failOnInconsistencies);
        identifiers.add(this._multilineValues);
        identifiers.add(this._headerLineNumber);
        identifiers.add(this._customColumnNames);
    }

    @Override
    public String toString() {
        return "CsvDatastore[name=" + this.getName() + ", filename=" + this._filename + ", quoteChar='" + this._quoteChar + "', separatorChar='" + this._separatorChar + "', encoding=" + this._encoding + ", headerLineNumber=" + this._headerLineNumber + "]";
    }
}

