/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UpdateableDatastore;
import org.datacleaner.connection.UpdateableDatastoreConnection;
import org.datacleaner.connection.UpdateableDatastoreConnectionImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.connection.UsernameDatastore;
import org.datacleaner.metamodel.datahub.DataHubConnection;
import org.datacleaner.metamodel.datahub.DataHubDataContext;
import org.datacleaner.metamodel.datahub.DataHubSecurityMode;

public class DataHubDatastore
extends UsageAwareDatastore<DataHubDataContext>
implements UpdateableDatastore,
UsernameDatastore {
    private static final long serialVersionUID = 1L;
    private final String _host;
    private final Integer _port;
    private final String _username;
    private final String _password;
    private final boolean _https;
    private final boolean _acceptUnverifiedSslPeers;
    private final DataHubSecurityMode _securityMode;

    public DataHubDatastore(String name, String host, Integer port, String username, String password, boolean https, boolean acceptUnverifiedSslPeers, DataHubSecurityMode dataHubSecurityMode) {
        super(name);
        this._host = host;
        this._port = port;
        this._username = username;
        this._password = password;
        this._https = https;
        this._acceptUnverifiedSslPeers = acceptUnverifiedSslPeers;
        this._securityMode = dataHubSecurityMode;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    public String getHost() {
        return this._host;
    }

    public Integer getPort() {
        return this._port;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public boolean isHttps() {
        return this._https;
    }

    public boolean isAcceptUnverifiedSslPeers() {
        return this._acceptUnverifiedSslPeers;
    }

    public DataHubSecurityMode getSecurityMode() {
        return this._securityMode;
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    @Override
    protected UsageAwareDatastoreConnection<DataHubDataContext> createDatastoreConnection() {
        DataHubConnection connection = new DataHubConnection(this._host, this._port, this._username, this._password, this._https, this._acceptUnverifiedSslPeers, this._securityMode);
        DataHubDataContext dataContext = new DataHubDataContext(connection);
        return new UpdateableDatastoreConnectionImpl<DataHubDataContext>(dataContext, this, new AutoCloseable[0]);
    }

    @Override
    public String toString() {
        return "DataHubDatastore[host= " + this._host + ", port=" + this._port + ", username=" + this._username + ", https=" + this._https + ", acceptUnverifiedSslPeers=" + this._acceptUnverifiedSslPeers + ", securityMode=" + (Object)((Object)this._securityMode) + "]";
    }
}

