/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import org.apache.metamodel.DataContext;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.SchemaNavigator;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreConnectionImpl<E extends DataContext>
extends UsageAwareDatastoreConnection<E> {
    private static final Logger logger = LoggerFactory.getLogger(DatastoreConnectionImpl.class);
    private final E _dataContext;
    private final SchemaNavigator _schemaNavigator;
    private final AutoCloseable[] _closeables;

    public DatastoreConnectionImpl(E dataContext, Datastore datastore, AutoCloseable ... closeables) {
        super(datastore);
        this._dataContext = dataContext;
        this._schemaNavigator = new SchemaNavigator(dataContext);
        this._closeables = closeables;
    }

    @Override
    public final E getDataContext() {
        return this._dataContext;
    }

    public final SchemaNavigator getSchemaNavigator() {
        return this._schemaNavigator;
    }

    @Override
    protected final void closeInternal() {
        for (int i = 0; i < this._closeables.length; ++i) {
            AutoCloseable closeable = this._closeables[i];
            try {
                closeable.close();
                continue;
            }
            catch (Exception e) {
                logger.error("Could not close _closeables[" + i + "]", (Throwable)e);
            }
        }
    }
}

