/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import com.google.common.base.Strings;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.util.SimpleTableDef;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UpdateableDatastore;
import org.datacleaner.connection.UpdateableDatastoreConnection;
import org.datacleaner.connection.UpdateableDatastoreConnectionImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.util.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class ElasticSearchDatastore
extends UsageAwareDatastore<UpdateableDataContext>
implements UpdateableDatastore {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PORT = 9200;
    public static final int TRANSPORT_PORT = 9300;
    private final SimpleTableDef[] _tableDefs;
    private final ClientType _clientType;
    private final String _indexName;
    private final String _hostname;
    private final Integer _port;
    private final String _clusterName;
    private final String _username;
    private final String _password;
    private final boolean _ssl;
    private final String _keystorePath;
    private final String _keystorePassword;

    public ElasticSearchDatastore(String name, ClientType clientType, String hostname, Integer port, String clusterName, String indexName) {
        this(name, clientType, hostname, port, clusterName, indexName, null, null, null, false, null, null);
    }

    public ElasticSearchDatastore(String name, ClientType clientType, String hostname, Integer port, String clusterName, String indexName, String username, String password, boolean ssl, String keystorePath, String keystorePassword) {
        this(name, clientType, hostname, port, clusterName, indexName, null, username, password, ssl, keystorePath, keystorePassword);
    }

    public ElasticSearchDatastore(String name, ClientType clientType, String hostname, Integer port, String clusterName, String indexName, SimpleTableDef[] tableDefs, String username, String password, boolean ssl, String keystorePath, String keystorePassword) {
        super(name);
        this._hostname = hostname;
        this._port = port;
        this._clusterName = clusterName;
        this._indexName = indexName;
        this._tableDefs = tableDefs;
        this._username = username;
        this._password = password;
        this._ssl = ssl;
        this._clientType = clientType;
        this._keystorePath = keystorePath;
        this._keystorePassword = keystorePassword;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    protected UsageAwareDatastoreConnection<UpdateableDataContext> createDatastoreConnection() {
        if (this._tableDefs == null || this._tableDefs.length == 0) {
            if (this._clientType.equals((Object)ClientType.NODE) || this._clientType.equals((Object)ClientType.TRANSPORT)) {
                Client client = this.getClientForNodeAndTransportProtocol();
                ElasticSearchDataContext dataContext = new ElasticSearchDataContext(client, this._indexName);
                return this.createConnection((DataContext)dataContext, client);
            }
            ElasticSearchRestDataContext dataContext = new ElasticSearchRestDataContext(this.getClientForRestProtocol(), this._indexName);
            return this.createConnection((DataContext)dataContext, null);
        }
        if (this._clientType.equals((Object)ClientType.NODE) || this._clientType.equals((Object)ClientType.TRANSPORT)) {
            Client client = this.getClientForNodeAndTransportProtocol();
            ElasticSearchDataContext dataContext = new ElasticSearchDataContext(client, this._indexName, this._tableDefs);
            return this.createConnection((DataContext)dataContext, client);
        }
        ElasticSearchRestDataContext dataContext = new ElasticSearchRestDataContext(this.getClientForRestProtocol(), this._indexName, this._tableDefs);
        return this.createConnection((DataContext)dataContext, null);
    }

    private UsageAwareDatastoreConnection<UpdateableDataContext> createConnection(DataContext dataContext, Client simpleclient) {
        switch (this._clientType) {
            case NODE: 
            case TRANSPORT: {
                return new UpdateableDatastoreConnectionImpl<ElasticSearchDataContext>((ElasticSearchDataContext)dataContext, this, new AutoCloseable[]{simpleclient});
            }
            case REST: {
                return new UpdateableDatastoreConnectionImpl<ElasticSearchRestDataContext>((ElasticSearchRestDataContext)dataContext, this, new AutoCloseable[0]);
            }
        }
        return null;
    }

    private Client getClientForNodeAndTransportProtocol() {
        switch (this._clientType) {
            case NODE: {
                return this.getClientForJoiningClusterAsNode();
            }
            case TRANSPORT: {
                return this.getClientForTransportProtocol();
            }
        }
        return null;
    }

    private JestClient getClientForRestProtocol() {
        JestClientFactory factory = new JestClientFactory();
        HttpClientConfig.Builder builder = (HttpClientConfig.Builder)new HttpClientConfig.Builder("http://" + this._hostname + ":" + this._port).multiThreaded(true);
        if (!Strings.isNullOrEmpty((String)this._username)) {
            builder = builder.defaultCredentials(this._username, this._password);
        }
        factory.setHttpClientConfig(builder.build());
        return factory.getObject();
    }

    private Client getClientForJoiningClusterAsNode() {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.builder();
        settingsBuilder.put("name", "DataCleaner");
        settingsBuilder.put("shield.enabled", false);
        Settings settings = settingsBuilder.build();
        Node node = NodeBuilder.nodeBuilder().clusterName(this._clusterName).client(true).settings(settings).node();
        Client client = node.client();
        return client;
    }

    private Client getClientForTransportProtocol() {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.builder();
        settingsBuilder.put("name", "DataCleaner");
        settingsBuilder.put("cluster.name", this._clusterName);
        if (!StringUtils.isNullOrEmpty(this._username) && !StringUtils.isNullOrEmpty(this._password)) {
            settingsBuilder.put("shield.user", this._username + ":" + this._password);
            if (this._ssl) {
                if (!Strings.isNullOrEmpty((String)this._keystorePath)) {
                    settingsBuilder.put("shield.ssl.keystore.path", this._keystorePath);
                    settingsBuilder.put("shield.ssl.keystore.password", this._keystorePassword);
                }
                settingsBuilder.put("shield.transport.ssl", "true");
            }
        }
        Settings settings = settingsBuilder.build();
        TransportClient client = new TransportClient(settings);
        client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(this._hostname, this._port.intValue()));
        return client;
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    public SimpleTableDef[] getTableDefs() {
        return this._tableDefs;
    }

    public ClientType getClientType() {
        return this._clientType;
    }

    public String getHostname() {
        return this._hostname;
    }

    public Integer getPort() {
        return this._port;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public String getIndexName() {
        return this._indexName;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public boolean getSsl() {
        return this._ssl;
    }

    public String getKeystorePath() {
        return this._keystorePath;
    }

    public String getKeystorePassword() {
        return this._keystorePassword;
    }

    @Override
    public String toString() {
        return "ElasticSearchDatastore[name=" + this.getName() + "]";
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._clusterName);
        identifiers.add(this._hostname);
        identifiers.add(this._indexName);
        identifiers.add(this._tableDefs);
    }

    public static enum ClientType {
        NODE("Join cluster as a node"),
        TRANSPORT("Connect via Transport protocol"),
        REST("Connect via REST protocol");

        private String _humanReadableName;

        private ClientType(String humanReadableName) {
            this._humanReadableName = humanReadableName;
        }

        public String toString() {
            return this._humanReadableName;
        }
    }
}

