/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelDataContext;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.schema.naming.CustomColumnNamingStrategy;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SerializableRef;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.FileDatastore;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.ResourceDatastore;
import org.datacleaner.connection.UpdateableDatastore;
import org.datacleaner.connection.UpdateableDatastoreConnection;
import org.datacleaner.connection.UpdateableDatastoreConnectionImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.util.ReadObjectBuilder;

public final class ExcelDatastore
extends UsageAwareDatastore<UpdateableDataContext>
implements FileDatastore,
ResourceDatastore,
UpdateableDatastore {
    private static final long serialVersionUID = 1L;
    private final String _filename;
    private final SerializableRef<Resource> _resourceRef;
    private List<String> _customColumnNames;

    public ExcelDatastore(String name, Resource resource, String filename) {
        this(name, resource, filename, null);
    }

    public ExcelDatastore(String name, Resource resource, String filename, List<String> customColumnNames) {
        super(name);
        this._resourceRef = new SerializableRef((Object)resource);
        this._filename = filename;
        this._customColumnNames = customColumnNames;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, ExcelDatastore.class).readObject(stream);
    }

    @Override
    public Resource getResource() {
        if (this._resourceRef == null) {
            return null;
        }
        return (Resource)this._resourceRef.get();
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    public List<String> getCustomColumnNames() {
        return this._customColumnNames;
    }

    @Override
    protected UsageAwareDatastoreConnection<UpdateableDataContext> createDatastoreConnection() {
        Resource resource = this.getResource();
        ExcelConfiguration excelConfiguration = this.getExcelConfiguration();
        ExcelDataContext dc = resource == null ? new ExcelDataContext(new File(this._filename), excelConfiguration) : new ExcelDataContext(resource, excelConfiguration);
        return new UpdateableDatastoreConnectionImpl<ExcelDataContext>(dc, this, new AutoCloseable[0]);
    }

    private ExcelConfiguration getExcelConfiguration() {
        if (this._customColumnNames != null && this._customColumnNames.size() > 0) {
            return new ExcelConfiguration(1, (ColumnNamingStrategy)new CustomColumnNamingStrategy(this._customColumnNames), true, false);
        }
        return new ExcelConfiguration();
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(false, true);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
    }
}

