/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.DataContextFactory;
import org.apache.metamodel.fixedwidth.EbcdicConfiguration;
import org.apache.metamodel.fixedwidth.FixedWidthConfiguration;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SerializableRef;
import org.datacleaner.connection.DatastoreConnectionImpl;
import org.datacleaner.connection.FileDatastore;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.ResourceDatastore;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.util.ReadObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedWidthDatastore
extends UsageAwareDatastore<DataContext>
implements FileDatastore,
ResourceDatastore {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(FixedWidthDatastore.class);
    public static final String EBCDIC_PREFIX = "IBM0";
    private final String _filename;
    private final String _encoding;
    private final int _fixedValueWidth;
    private final int[] _valueWidths;
    private final boolean _failOnInconsistencies;
    private final boolean _skipEbcdicHeader;
    private final boolean _eolPresent;
    private final int _headerLineNumber;
    private final List<String> _customColumnNames;
    private final SerializableRef<Resource> _resourceRef;

    public FixedWidthDatastore(String name, String filename, String encoding, int fixedValueWidth) {
        this(name, filename, encoding, fixedValueWidth, true, false, true);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int[] valueWidths) {
        this(name, filename, encoding, valueWidths, true, false, true);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int fixedValueWidth, boolean failOnInconsistencies, boolean skipEbcdicHeader, boolean eolPresent) {
        this(name, filename, encoding, fixedValueWidth, failOnInconsistencies, skipEbcdicHeader, eolPresent, 1);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int[] valueWidths, boolean failOnInconsistencies, boolean skipEbcdicHeader, boolean eolPresent) {
        this(name, filename, encoding, valueWidths, failOnInconsistencies, skipEbcdicHeader, eolPresent, 1);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int fixedValueWidth, boolean failOnInconsistencies, boolean skipEbcdicHeader, boolean eolPresent, int headerLineNumber) {
        this(name, null, filename, encoding, fixedValueWidth, failOnInconsistencies, skipEbcdicHeader, eolPresent, headerLineNumber);
    }

    public FixedWidthDatastore(String name, Resource resource, String filename, String encoding, int fixedValueWidth, boolean failOnInconsistencies, boolean skipEbcdicHeader, boolean eolPresent, int headerLineNumber) {
        super(name);
        this._filename = filename;
        if (resource == null) {
            resource = new FileResource(filename);
        }
        this._resourceRef = new SerializableRef((Object)resource);
        this._encoding = encoding;
        this._fixedValueWidth = fixedValueWidth;
        this._valueWidths = new int[0];
        this._failOnInconsistencies = failOnInconsistencies;
        this._skipEbcdicHeader = skipEbcdicHeader;
        this._eolPresent = eolPresent;
        this._headerLineNumber = headerLineNumber;
        this._customColumnNames = null;
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int[] valueWidths, boolean failOnInconsistencies, boolean skipEbcdicHeader, boolean eolPresent, int headerLineNumber) {
        this(name, filename, encoding, valueWidths, failOnInconsistencies, skipEbcdicHeader, eolPresent, headerLineNumber, null);
    }

    public FixedWidthDatastore(String name, String filename, String encoding, int[] valueWidths, boolean failOnInconsistencies, boolean skipEbcdicHeader, boolean eolPresent, int headerLineNumber, List<String> customColumnNames) {
        this(name, null, filename, encoding, valueWidths, failOnInconsistencies, skipEbcdicHeader, eolPresent, headerLineNumber, null);
    }

    public FixedWidthDatastore(String name, Resource resource, String filename, String encoding, int[] valueWidths, boolean failOnInconsistencies, boolean skipEbcdicHeader, boolean eolPresent, int headerLineNumber, List<String> customColumnNames) {
        super(name);
        this._filename = filename;
        if (resource == null) {
            resource = new FileResource(filename);
        }
        this._resourceRef = new SerializableRef((Object)resource);
        this._encoding = encoding;
        this._fixedValueWidth = -1;
        this._valueWidths = valueWidths;
        this._failOnInconsistencies = failOnInconsistencies;
        this._skipEbcdicHeader = skipEbcdicHeader;
        this._eolPresent = eolPresent;
        this._headerLineNumber = headerLineNumber;
        this._customColumnNames = customColumnNames;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.Adaptor adaptor = new ReadObjectBuilder.Adaptor(){

            @Override
            public void deserialize(ObjectInputStream.GetField getField, Serializable serializable) throws Exception {
                String filename = (String)getField.get("_filename", "");
                Field field = FixedWidthDatastore.class.getDeclaredField("_resourceRef");
                field.setAccessible(true);
                FileResource fileResource = new FileResource(filename);
                SerializableRef resourceRef = new SerializableRef((Object)fileResource);
                field.set(serializable, resourceRef);
            }
        };
        ReadObjectBuilder.create(this, FixedWidthDatastore.class).readObject(stream, adaptor);
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(false, true);
    }

    @Override
    protected UsageAwareDatastoreConnection<DataContext> createDatastoreConnection() {
        DataContext dataContext;
        FixedWidthConfiguration configuration = this.getConfiguration();
        Resource resource = (Resource)this._resourceRef.get();
        if (resource == null) {
            logger.warn("Resource was not available, a local file reference will be created with path: {}", (Object)this._filename);
            dataContext = DataContextFactory.createFixedWidthDataContext((File)new File(this._filename), (FixedWidthConfiguration)configuration);
        } else {
            dataContext = DataContextFactory.createFixedWidthDataContext((Resource)resource, (FixedWidthConfiguration)configuration);
        }
        return new DatastoreConnectionImpl<DataContext>(dataContext, this, new AutoCloseable[0]);
    }

    public FixedWidthConfiguration getConfiguration() {
        Object configuration = this.isEbcdic() ? (this._fixedValueWidth == -1 ? new EbcdicConfiguration(this._headerLineNumber, this._encoding, this._valueWidths, this._failOnInconsistencies, this._skipEbcdicHeader, this._eolPresent) : new EbcdicConfiguration(this._headerLineNumber, this._encoding, this._fixedValueWidth, this._failOnInconsistencies, this._skipEbcdicHeader, this._eolPresent)) : (this._fixedValueWidth == -1 ? new FixedWidthConfiguration(this._headerLineNumber, this._encoding, this._valueWidths, this._failOnInconsistencies) : new FixedWidthConfiguration(this._headerLineNumber, this._encoding, this._fixedValueWidth, this._failOnInconsistencies));
        return configuration;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public int getFixedValueWidth() {
        return this._fixedValueWidth;
    }

    public int[] getValueWidths() {
        return this._valueWidths;
    }

    public int getHeaderLineNumber() {
        return this._headerLineNumber;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public Resource getResource() {
        if (this._resourceRef == null) {
            return null;
        }
        return (Resource)this._resourceRef.get();
    }

    public boolean isFailOnInconsistencies() {
        return this._failOnInconsistencies;
    }

    public boolean isSkipEbcdicHeader() {
        return this._skipEbcdicHeader;
    }

    public boolean isEolPresent() {
        return this._eolPresent;
    }

    public List<String> getCustomColumnNames() {
        return this._customColumnNames;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
        identifiers.add(this._encoding);
        identifiers.add(this._fixedValueWidth);
        identifiers.add(this._valueWidths);
        identifiers.add(this._headerLineNumber);
        identifiers.add(this._failOnInconsistencies);
        identifiers.add(this._skipEbcdicHeader);
        identifiers.add(this._eolPresent);
    }

    private boolean isEbcdic() {
        return this.getEncoding().startsWith(EBCDIC_PREFIX);
    }

    @Override
    public String toString() {
        return "FixedWidthDatastore[name=" + this.getName() + ", filename=" + this._filename + ", encoding=" + this._encoding + ", headerLineNumber=" + this._headerLineNumber + ", valueWidths=" + Arrays.toString(this._valueWidths) + ", fixedValueWidth=" + this._fixedValueWidth + "]";
    }
}

