/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.schema.TableType;
import org.datacleaner.connection.DataSourceDatastoreConnection;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UpdateableDatastore;
import org.datacleaner.connection.UpdateableDatastoreConnection;
import org.datacleaner.connection.UpdateableDatastoreConnectionImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.connection.UsernameDatastore;
import org.datacleaner.util.ReadObjectBuilder;
import org.datacleaner.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDatastore
extends UsageAwareDatastore<UpdateableDataContext>
implements UpdateableDatastore,
UsernameDatastore {
    private static final long serialVersionUID = 1L;
    public static final String SYSTEM_PROPERTY_CONNECTION_POOL_MAX_SIZE = "datastore.jdbc.connection.pool.max.size";
    public static final String SYSTEM_PROPERTY_CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME_MILLIS = "datastore.jdbc.connection.pool.idle.timeout";
    public static final String SYSTEM_PROPERTY_CONNECTION_POOL_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "datastore.jdbc.connection.pool.eviction.period.millis";
    private static final Logger logger = LoggerFactory.getLogger(JdbcDatastore.class);
    private final String _jdbcUrl;
    private final String _username;
    private final String _password;
    private final String _driverClass;
    private final boolean _multipleConnections;
    private final String _datasourceJndiUrl;
    private final TableType[] _tableTypes;
    private final String _catalogName;

    private JdbcDatastore(String name, String jdbcUrl, String driverClass, String username, String password, String datasourceJndiUrl, boolean multipleConnections, TableType[] tableTypes, String catalogName) {
        super(name);
        this._jdbcUrl = jdbcUrl;
        this._driverClass = driverClass;
        this._username = username;
        this._password = password;
        this._datasourceJndiUrl = datasourceJndiUrl;
        this._multipleConnections = multipleConnections;
        this._tableTypes = tableTypes;
        this._catalogName = catalogName;
    }

    public JdbcDatastore(String name, String jdbcUrl, String driverClass) {
        this(name, jdbcUrl, driverClass, null, null, true);
    }

    public JdbcDatastore(String name, String jdbcUrl, String driverClass, String username, String password, boolean multipleConnections, TableType[] tableTypes, String catalogName) {
        this(name, jdbcUrl, driverClass, username, password, null, multipleConnections, tableTypes, catalogName);
    }

    public JdbcDatastore(String name, String jdbcUrl, String driverClass, String username, String password, boolean multipleConnections) {
        this(name, jdbcUrl, driverClass, username, password, multipleConnections, null, null);
    }

    public JdbcDatastore(String name, String datasourceJndiUrl) {
        this(name, datasourceJndiUrl, null, null);
    }

    public JdbcDatastore(String name, String datasourceJndiUrl, TableType[] tableTypes, String catalogName) {
        this(name, null, null, null, null, datasourceJndiUrl, false, tableTypes, catalogName);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, JdbcDatastore.class).readObject(stream);
    }

    public UpdateableDatastoreConnection openConnection() {
        DatastoreConnection connection = super.openConnection();
        return (UpdateableDatastoreConnection)connection;
    }

    public JdbcDatastore(String name, UpdateableDataContext dc) {
        this(name, null, null, null, null, null, false, null, null);
        this.setDataContextProvider(new UpdateableDatastoreConnectionImpl<UpdateableDataContext>(dc, this, new AutoCloseable[0]));
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._driverClass);
        identifiers.add(this._jdbcUrl);
        identifiers.add(this._datasourceJndiUrl);
        identifiers.add(this._username);
        identifiers.add(this._password);
        identifiers.add(this._multipleConnections);
        identifiers.add(this.getTableTypes());
    }

    public boolean isMultipleConnections() {
        return this._multipleConnections;
    }

    public TableType[] getTableTypes() {
        TableType[] tableTypes = this._tableTypes == null ? TableType.DEFAULT_TABLE_TYPES : this._tableTypes;
        return Arrays.copyOf(tableTypes, tableTypes.length);
    }

    public String getCatalogName() {
        return this._catalogName;
    }

    public String getJdbcUrl() {
        return this._jdbcUrl;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public String getDriverClass() {
        return this._driverClass;
    }

    public String getDatasourceJndiUrl() {
        return this._datasourceJndiUrl;
    }

    public Connection createConnection() throws IllegalStateException {
        this.initializeDriver();
        try {
            if (this._username != null && this._password != null) {
                return DriverManager.getConnection(this._jdbcUrl, this._username, this._password);
            }
            return DriverManager.getConnection(this._jdbcUrl);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not create connection", e);
        }
    }

    public DataSource createDataSource() {
        this.initializeDriver();
        BasicDataSource ds = new BasicDataSource();
        ds.setDefaultAutoCommit(false);
        ds.setUrl(this._jdbcUrl);
        ds.setMaxActive(this.getSystemPropertyValue(SYSTEM_PROPERTY_CONNECTION_POOL_MAX_SIZE, -1));
        ds.setMinEvictableIdleTimeMillis((long)this.getSystemPropertyValue(SYSTEM_PROPERTY_CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME_MILLIS, 500));
        ds.setTimeBetweenEvictionRunsMillis((long)this.getSystemPropertyValue(SYSTEM_PROPERTY_CONNECTION_POOL_TIME_BETWEEN_EVICTION_RUNS_MILLIS, 1000));
        if (this._username != null && this._password != null) {
            ds.setUsername(this._username);
            ds.setPassword(this._password);
        }
        return ds;
    }

    private int getSystemPropertyValue(String property, int defaultValue) {
        String str = System.getProperty(property);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            logger.debug("Failed to parse system property '{}': '{}'", (Object)property, (Object)str);
            return defaultValue;
        }
    }

    private void initializeDriver() {
        if (this._jdbcUrl == null) {
            throw new IllegalStateException("JDBC URL is null, cannot create connection!");
        }
        logger.debug("Determining if driver initialization is nescesary");
        boolean installDriver = true;
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                if (!driver.acceptsURL(this._jdbcUrl)) continue;
                installDriver = false;
                break;
            }
            catch (Exception e) {
                logger.warn("Driver threw exception when acceptURL(...) was invoked", (Throwable)e);
            }
        }
        if (installDriver) {
            try {
                Class.forName(this._driverClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not initialize JDBC driver", e);
            }
        }
    }

    @Override
    protected UsageAwareDatastoreConnection<UpdateableDataContext> createDatastoreConnection() {
        if (StringUtils.isNullOrEmpty(this._datasourceJndiUrl)) {
            if (this.isMultipleConnections()) {
                DataSource dataSource = this.createDataSource();
                return new DataSourceDatastoreConnection(dataSource, this.getTableTypes(), this._catalogName, this);
            }
            Connection connection = this.createConnection();
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                logger.error("Could not set autocommit false '{}'", (Object)this._datasourceJndiUrl);
                throw new IllegalStateException(e);
            }
            JdbcDataContext dataContext = new JdbcDataContext(connection, this.getTableTypes(), this._catalogName);
            return new UpdateableDatastoreConnectionImpl<JdbcDataContext>(dataContext, this, new AutoCloseable[0]);
        }
        try {
            Context initialContext = this.getJndiNamingContext();
            DataSource dataSource = (DataSource)initialContext.lookup(this._datasourceJndiUrl);
            return new DataSourceDatastoreConnection(dataSource, this.getTableTypes(), this._catalogName, this);
        }
        catch (Exception e) {
            logger.error("Could not retrieve DataSource '{}'", (Object)this._datasourceJndiUrl);
            throw new IllegalStateException(e);
        }
    }

    protected Context getJndiNamingContext() throws NamingException {
        return new InitialContext();
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JdbcDatastore[name=");
        sb.append(this.getName());
        if (this._jdbcUrl != null) {
            sb.append(",url=");
            sb.append(this._jdbcUrl);
        } else {
            sb.append(",jndi=");
            sb.append(this._datasourceJndiUrl);
        }
        sb.append("]");
        return sb.toString();
    }
}

