/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.util.List;
import org.apache.metamodel.json.JsonDataContext;
import org.apache.metamodel.schema.builder.SchemaBuilder;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SerializableRef;
import org.datacleaner.connection.DatastoreConnectionImpl;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.ResourceDatastore;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;

public class JsonDatastore
extends UsageAwareDatastore<JsonDataContext>
implements ResourceDatastore {
    private static final long serialVersionUID = 1L;
    private final SerializableRef<Resource> _resourceRef;
    private final SerializableRef<SchemaBuilder> _schemaBuilderRef;

    public JsonDatastore(String name, Resource resource) {
        this(name, resource, null);
    }

    public JsonDatastore(String name, Resource resource, SchemaBuilder schemaBuilder) {
        super(name);
        this._resourceRef = new SerializableRef((Object)resource);
        this._schemaBuilderRef = new SerializableRef((Object)schemaBuilder);
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(false, true);
    }

    @Override
    protected UsageAwareDatastoreConnection<JsonDataContext> createDatastoreConnection() {
        Resource resource = (Resource)this._resourceRef.get();
        SchemaBuilder schemaBuilder = (SchemaBuilder)this._schemaBuilderRef.get();
        JsonDataContext dataContext = schemaBuilder == null ? new JsonDataContext(resource) : new JsonDataContext(resource, schemaBuilder);
        return new DatastoreConnectionImpl<JsonDataContext>(dataContext, this, new AutoCloseable[0]);
    }

    public SchemaBuilder getSchemaBuilder() {
        return (SchemaBuilder)this._schemaBuilderRef.get();
    }

    @Override
    public Resource getResource() {
        return (Resource)this._resourceRef.get();
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._resourceRef);
    }
}

